/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.CreditMemoItemCreateRequest;
import org.threeten.bp.LocalDate;

public class CreditMemoCreateRequest {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_DOCUMENT_DATE = "document_date";
    @SerializedName(value="document_date")
    private LocalDate documentDate;
    public static final String SERIALIZED_NAME_REASON_CODE = "reason_code";
    @SerializedName(value="reason_code")
    private String reasonCode;
    public static final String SERIALIZED_NAME_INVOICE_ID = "invoice_id";
    @SerializedName(value="invoice_id")
    private String invoiceId;
    public static final String SERIALIZED_NAME_TRANSFER_TO_ACCOUNTING = "transfer_to_accounting";
    @SerializedName(value="transfer_to_accounting")
    private Boolean transferToAccounting;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;
    public static final String SERIALIZED_NAME_EXCLUDE_FROM_AUTO_APPLY_RULES = "exclude_from_auto_apply_rules";
    @SerializedName(value="exclude_from_auto_apply_rules")
    private Boolean excludeFromAutoApplyRules;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<CreditMemoItemCreateRequest> items = null;
    public static final String SERIALIZED_NAME_APPLY = "apply";
    @SerializedName(value="apply")
    private Boolean apply;
    public static final String SERIALIZED_NAME_POST = "post";
    @SerializedName(value="post")
    private Boolean post;

    public CreditMemoCreateRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the account that owns the credit memo.     **Either this field or `account_number` is required when creating credit memos from a price(charge in the v1 API).**")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public CreditMemoCreateRequest accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="RC-00020831", value="Human-readable identifier of the account that owns the credit memo.    **Either this field or `account_id` is required when creating credit memos from a price(charge in the v1 API).**")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public CreditMemoCreateRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary string associated with the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreditMemoCreateRequest documentDate(LocalDate documentDate) {
        this.documentDate = documentDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="The date when the credit memo takes effect.")
    public LocalDate getDocumentDate() {
        return this.documentDate;
    }

    public void setDocumentDate(LocalDate documentDate) {
        this.documentDate = documentDate;
    }

    public CreditMemoCreateRequest reasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Reason for issuing this credit memo")
    public String getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    public CreditMemoCreateRequest invoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of the invoice billing document from which this credit memo is created.      **Required when creating credit memos from an invoice.**")
    public String getInvoiceId() {
        return this.invoiceId;
    }

    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    public CreditMemoCreateRequest transferToAccounting(Boolean transferToAccounting) {
        this.transferToAccounting = transferToAccounting;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether to transfer to an external accounting system.")
    public Boolean getTransferToAccounting() {
        return this.transferToAccounting;
    }

    public void setTransferToAccounting(Boolean transferToAccounting) {
        this.transferToAccounting = transferToAccounting;
    }

    public CreditMemoCreateRequest customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public CreditMemoCreateRequest putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    public CreditMemoCreateRequest excludeFromAutoApplyRules(Boolean excludeFromAutoApplyRules) {
        this.excludeFromAutoApplyRules = excludeFromAutoApplyRules;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether to exclude this credit memo from the rule of automatically applying it to invoices.")
    public Boolean getExcludeFromAutoApplyRules() {
        return this.excludeFromAutoApplyRules;
    }

    public void setExcludeFromAutoApplyRules(Boolean excludeFromAutoApplyRules) {
        this.excludeFromAutoApplyRules = excludeFromAutoApplyRules;
    }

    public CreditMemoCreateRequest currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="3-letter ISO 4217 currency code. This field is available only if you have the [Multiple Currencies](https://knowledgecenter.zuora.com/Zuora_Billing/Bill_your_customers/Flexible_Billing/Multiple_Currencies) feature enabled and are creating a credit memo from a charge.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public CreditMemoCreateRequest items(List<CreditMemoItemCreateRequest> items) {
        this.items = items;
        return this;
    }

    public CreditMemoCreateRequest addItemsItem(CreditMemoItemCreateRequest itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<CreditMemoItemCreateRequest>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Information of all credit memo items.")
    public List<CreditMemoItemCreateRequest> getItems() {
        return this.items;
    }

    public void setItems(List<CreditMemoItemCreateRequest> items) {
        this.items = items;
    }

    public CreditMemoCreateRequest apply(Boolean apply) {
        this.apply = apply;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether to automatically apply the billing document upon posting.")
    public Boolean getApply() {
        return this.apply;
    }

    public void setApply(Boolean apply) {
        this.apply = apply;
    }

    public CreditMemoCreateRequest post(Boolean post) {
        this.post = post;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether to automatically post a billing document after it is created.")
    public Boolean getPost() {
        return this.post;
    }

    public void setPost(Boolean post) {
        this.post = post;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditMemoCreateRequest creditMemoCreateRequest = (CreditMemoCreateRequest)o;
        return Objects.equals(this.accountId, creditMemoCreateRequest.accountId) && Objects.equals(this.accountNumber, creditMemoCreateRequest.accountNumber) && Objects.equals(this.description, creditMemoCreateRequest.description) && Objects.equals(this.documentDate, creditMemoCreateRequest.documentDate) && Objects.equals(this.reasonCode, creditMemoCreateRequest.reasonCode) && Objects.equals(this.invoiceId, creditMemoCreateRequest.invoiceId) && Objects.equals(this.transferToAccounting, creditMemoCreateRequest.transferToAccounting) && Objects.equals(this.customFields, creditMemoCreateRequest.customFields) && Objects.equals(this.excludeFromAutoApplyRules, creditMemoCreateRequest.excludeFromAutoApplyRules) && Objects.equals(this.currency, creditMemoCreateRequest.currency) && Objects.equals(this.items, creditMemoCreateRequest.items) && Objects.equals(this.apply, creditMemoCreateRequest.apply) && Objects.equals(this.post, creditMemoCreateRequest.post);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.accountNumber, this.description, this.documentDate, this.reasonCode, this.invoiceId, this.transferToAccounting, this.customFields, this.excludeFromAutoApplyRules, this.currency, this.items, this.apply, this.post);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditMemoCreateRequest {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    documentDate: ").append(this.toIndentedString(this.documentDate)).append("\n");
        sb.append("    reasonCode: ").append(this.toIndentedString(this.reasonCode)).append("\n");
        sb.append("    invoiceId: ").append(this.toIndentedString(this.invoiceId)).append("\n");
        sb.append("    transferToAccounting: ").append(this.toIndentedString(this.transferToAccounting)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    excludeFromAutoApplyRules: ").append(this.toIndentedString(this.excludeFromAutoApplyRules)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    apply: ").append(this.toIndentedString(this.apply)).append("\n");
        sb.append("    post: ").append(this.toIndentedString(this.post)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

