/*
 * Decompiled with CFR 0.152.
 */
package com.zvoykish.restdl.generator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.zvoykish.restdl.generator.HttpClientFactoryInterface;
import com.zvoykish.restdl.generator.RestdlGeneratorProvider;
import com.zvoykish.restdl.generator.java.JavaRestdlGeneratorProvider;
import com.zvoykish.restdl.objects.AnObject;
import com.zvoykish.restdl.objects.ApiDetailsResponse;
import com.zvoykish.restdl.objects.EndpointInfo;
import com.zvoykish.restdl.objects.TypedObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Restdl2Code {
    private final RestdlGeneratorProvider provider = new JavaRestdlGeneratorProvider();

    public static void main(String[] args) {
        if (args == null || args.length != 2) {
            System.out.println("Invalid arguments. Please use the following syntax: Restdl2Code [Restdl URL] [Target package for client]");
            System.exit(1);
        }
        try {
            new Restdl2Code().run(args[0], args[1]);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(99);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String url, String basePackage) throws IOException {
        String baseTargetDir = System.getProperty("targetDir");
        if ((baseTargetDir = baseTargetDir + System.currentTimeMillis()) == null || baseTargetDir.trim().isEmpty()) {
            throw new RuntimeException("Invalid target dir!");
        }
        if (new File(baseTargetDir).exists()) {
            throw new RuntimeException("Target dir already exists, please provide a non-existing target dir so it includes only the generated code: " + baseTargetDir);
        }
        try (InputStream is = null;){
            URLConnection urlConnection = new URL(url).openConnection();
            urlConnection.connect();
            is = urlConnection.getInputStream();
            ApiDetailsResponse api = (ApiDetailsResponse)new ObjectMapper().readValue(is, ApiDetailsResponse.class);
            Path targetPath = Paths.get(baseTargetDir, new String[0]);
            Map<Long, TypedObject> types = this.generateTypes(api, targetPath);
            this.generateMethods(api, types);
            this.generateApi(api, types, targetPath, basePackage);
        }
    }

    private void generateApi(ApiDetailsResponse api, Map<Long, TypedObject> types, Path targetPath, String targetPackage) throws IOException {
        String fullClassPath = this.provider.classNameToPath(targetPackage + '.' + "RestdlApiClient");
        Path tempPath = targetPath.resolve(fullClassPath);
        Path fileTargetFolder = tempPath.getParent();
        String className = tempPath.getFileName().toString();
        this.generateClientFactory(targetPackage, fileTargetFolder);
        this.generateApiInterface(api.getEndpoints(), targetPackage, className, fileTargetFolder, types);
        this.generateApiImplementation(api.getEndpoints(), targetPackage, className + "Impl", fileTargetFolder, types);
    }

    private Map<Long, TypedObject> generateTypes(ApiDetailsResponse api, Path targetPath) throws IOException {
        List types = api.getTypes();
        HashMap<Long, TypedObject> typeMap = new HashMap<Long, TypedObject>();
        for (TypedObject type : types) {
            typeMap.put(type.getId(), type);
        }
        for (TypedObject type : types) {
            type.unReferenceFields(typeMap);
        }
        File targetPathAsFile = targetPath.toFile();
        if (targetPathAsFile.exists()) {
            targetPathAsFile.delete();
        }
        Files.createDirectories(targetPath, new FileAttribute[0]);
        for (TypedObject type : types) {
            String objectTypeClass = type.getClassName();
            if (this.provider.isIgnoredType(objectTypeClass)) {
                System.out.println("Unhandled class: " + type);
                continue;
            }
            String fullClassPath = this.provider.classNameToPath(objectTypeClass);
            Path tempPath = targetPath.resolve(fullClassPath);
            Path fileTargetFolder = tempPath.getParent();
            String className = tempPath.getFileName().toString();
            String contents = this.provider.generateTypeContents(type, className, typeMap);
            if (contents == null) {
                System.out.println("Invalid...");
                continue;
            }
            this.writeToFile(contents, fileTargetFolder, className + '.' + this.provider.getClassFileExtension());
        }
        return typeMap;
    }

    private void generateMethods(ApiDetailsResponse api, Map<Long, TypedObject> types) throws IOException {
        for (EndpointInfo endpointInfo : api.getEndpoints()) {
            List queryParams;
            TypedObject returnType;
            TypedObject requestParam = endpointInfo.getRequestParam();
            if (requestParam != null) {
                endpointInfo.setRequestParam(types.get(requestParam.getId()));
            }
            if ((returnType = endpointInfo.getReturnType()) != null) {
                endpointInfo.setReturnType(types.get(returnType.getId()));
            }
            if ((queryParams = endpointInfo.getQueryParams()) == null) continue;
            for (AnObject object : queryParams) {
                object.setType(types.get(object.getType().getId()));
            }
        }
    }

    private void generateClientFactory(String targetPackage, Path fileTargetFolder) throws IOException {
        HttpClientFactoryInterface clientFactory = this.provider.generateHttpClientFactory(targetPackage);
        String filename = clientFactory.getClassName() + '.' + this.provider.getClassFileExtension();
        this.writeToFile(clientFactory.getContents(), fileTargetFolder, filename);
    }

    private void generateApiImplementation(List<EndpointInfo> endpoints, String packageName, String className, Path targetPath, Map<Long, TypedObject> types) throws IOException {
        String content = this.provider.generateApiImplementation(endpoints, className, packageName, types);
        this.writeToFile(content, targetPath, className + '.' + this.provider.getClassFileExtension());
    }

    private void generateApiInterface(List<EndpointInfo> endpoints, String packageName, String className, Path targetPath, Map<Long, TypedObject> types) throws IOException {
        String content = this.provider.generateApiInterface(endpoints, className, packageName, types);
        this.writeToFile(content, targetPath, className + '.' + this.provider.getClassFileExtension());
    }

    private void writeToFile(String contents, Path folder, String filename) throws IOException {
        Files.createDirectories(folder, new FileAttribute[0]);
        Path file = Files.createFile(folder.resolve(filename), new FileAttribute[0]);
        Files.write(file, contents.getBytes("UTF-8"), new OpenOption[0]);
    }
}

