/*
 * Decompiled with CFR 0.152.
 */
package com.zvoykish.restdl.generator.java;

import com.zvoykish.restdl.generator.ContentGenerator;
import com.zvoykish.restdl.generator.HttpClientFactoryInterface;
import com.zvoykish.restdl.generator.HttpClientFactoryInterfaceImpl;
import com.zvoykish.restdl.generator.RestdlGeneratorProvider;
import com.zvoykish.restdl.generator.java.JavaWriter;
import com.zvoykish.restdl.generator.java.impl.ClassContentGenerator;
import com.zvoykish.restdl.generator.java.impl.EnumObjectContentGenerator;
import com.zvoykish.restdl.generator.java.impl.PrimitiveObjectContentGenerator;
import com.zvoykish.restdl.objects.EndpointInfo;
import com.zvoykish.restdl.objects.TypedObject;
import com.zvoykish.restdl.objects.TypedObjectType;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class JavaRestdlGeneratorProvider
implements RestdlGeneratorProvider {
    public static final String CLASS_NAME_REST_TEMPLATE_FACTORY = "RestdlRestTemplateFactory";
    private final JavaWriter writer = new JavaWriter();
    private final Map<TypedObjectType, ContentGenerator> contentGeneratorMap = new HashMap<TypedObjectType, ContentGenerator>();

    public JavaRestdlGeneratorProvider() {
        this.contentGeneratorMap.put(TypedObjectType.Primitive, new PrimitiveObjectContentGenerator());
        this.contentGeneratorMap.put(TypedObjectType.Enum, new EnumObjectContentGenerator());
        this.contentGeneratorMap.put(TypedObjectType.Other, new ClassContentGenerator(this.writer));
        Properties p = new Properties();
        p.setProperty("resource.loader", "class");
        p.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.init((Properties)p);
    }

    @Override
    public boolean isIgnoredType(String objectTypeClass) {
        return objectTypeClass == null || objectTypeClass.indexOf(46) == -1 || objectTypeClass.indexOf(60) > -1 || objectTypeClass.indexOf(91) > -1;
    }

    @Override
    public String generateTypeContents(TypedObject type, String className, Map<Long, TypedObject> typeMap) {
        String objectTypeClass = type.getClassName();
        if (objectTypeClass == null || objectTypeClass.indexOf(46) == -1 || objectTypeClass.indexOf(60) > -1 || objectTypeClass.indexOf(91) > -1) {
            System.out.println("Unhandled class: " + type);
            return null;
        }
        String targetPackage = this.getPackage(objectTypeClass);
        String contents = this.generateClassContents(type, targetPackage, className, typeMap);
        return contents;
    }

    @Override
    public String generateApiInterface(List<EndpointInfo> endpoints, String className, String packageName, Map<Long, TypedObject> typeMap) {
        Template template = Velocity.getTemplate((String)"templates/interface.vm");
        StringWriter stringWriter = new StringWriter();
        VelocityContext context = new VelocityContext();
        context.put("packageName", (Object)packageName);
        context.put("interfaceName", (Object)className);
        context.put("endpoints", endpoints);
        context.put("writer", (Object)this.writer);
        context.put("types", typeMap);
        template.merge((Context)context, (Writer)stringWriter);
        return stringWriter.toString();
    }

    @Override
    public String generateApiImplementation(List<EndpointInfo> endpoints, String className, String packageName, Map<Long, TypedObject> typeMap) {
        Template template = Velocity.getTemplate((String)"templates/class.vm");
        StringWriter stringWriter = new StringWriter();
        VelocityContext context = new VelocityContext();
        context.put("packageName", (Object)packageName);
        context.put("clientFactoryClassName", (Object)CLASS_NAME_REST_TEMPLATE_FACTORY);
        context.put("superInterfaces", (Object)new String[]{className.substring(0, className.length() - 4)});
        context.put("className", (Object)className);
        context.put("endpoints", endpoints);
        context.put("writer", (Object)this.writer);
        context.put("types", typeMap);
        template.merge((Context)context, (Writer)stringWriter);
        return stringWriter.toString();
    }

    @Override
    public HttpClientFactoryInterface generateHttpClientFactory(String packageName) {
        Template template = Velocity.getTemplate((String)"templates/resttemplate_factory.vm");
        StringWriter stringWriter = new StringWriter();
        VelocityContext context = new VelocityContext();
        context.put("packageName", (Object)packageName);
        context.put("factoryInterfaceName", (Object)CLASS_NAME_REST_TEMPLATE_FACTORY);
        template.merge((Context)context, (Writer)stringWriter);
        return new HttpClientFactoryInterfaceImpl(CLASS_NAME_REST_TEMPLATE_FACTORY, stringWriter.toString());
    }

    @Override
    public String getClassFileExtension() {
        return "java";
    }

    @Override
    public String classNameToPath(String targetPackage) {
        return targetPackage.replace('.', File.separatorChar).replace('$', '_');
    }

    private String getPackage(String objectTypeClass) {
        return objectTypeClass.substring(0, objectTypeClass.lastIndexOf(46));
    }

    private String generateClassContents(TypedObject typedObject, String targetPackage, String className, Map<Long, TypedObject> typeMap) {
        TypedObjectType typedObjectType = TypedObjectType.fromString((String)typedObject.getType());
        ContentGenerator contentGenerator = this.contentGeneratorMap.get(typedObjectType);
        if (contentGenerator != null) {
            String content = contentGenerator.generateContent(typedObject, className, typeMap);
            if (content == null) {
                return null;
            }
            Template template = Velocity.getTemplate((String)"templates/package_with_contents.vm");
            StringWriter stringWriter = new StringWriter();
            VelocityContext context = new VelocityContext();
            context.put("packageName", (Object)targetPackage);
            context.put("contents", (Object)content);
            template.merge((Context)context, (Writer)stringWriter);
            return stringWriter.toString();
        }
        return null;
    }
}

