/*
 * Decompiled with CFR 0.152.
 */
package com.zvoykish.restdl.generator.java.impl;

import com.zvoykish.restdl.generator.ContentGenerator;
import com.zvoykish.restdl.generator.java.JavaWriter;
import com.zvoykish.restdl.objects.AnObject;
import com.zvoykish.restdl.objects.ComplexObject;
import com.zvoykish.restdl.objects.GenericDeclarationObject;
import com.zvoykish.restdl.objects.TypedObject;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class ComplexObjectGenerator
implements ContentGenerator<ComplexObject> {
    private final JavaWriter writer;

    public ComplexObjectGenerator(JavaWriter writer) {
        this.writer = writer;
    }

    @Override
    public String generateContent(ComplexObject object, String className, Map<Long, TypedObject> typeMap) {
        Template template = Velocity.getTemplate((String)"templates/object_class.vm");
        StringWriter stringWriter = new StringWriter();
        VelocityContext context = new VelocityContext();
        List fields = object.getFields();
        context.put("className", (Object)this.getClassName(className, fields));
        context.put("fields", (Object)fields);
        context.put("writer", (Object)this.writer);
        context.put("types", typeMap);
        template.merge((Context)context, (Writer)stringWriter);
        return stringWriter.toString();
    }

    private String getClassName(String className, List<AnObject> fields) {
        ArrayList<String> genericObjects = new ArrayList<String>();
        for (AnObject field : fields) {
            TypedObject fieldType = field.getType();
            if (!(fieldType instanceof GenericDeclarationObject)) continue;
            genericObjects.add(fieldType.getClassName());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(className);
        if (!genericObjects.isEmpty()) {
            sb.append('<');
            for (int i = 0; i < genericObjects.size(); ++i) {
                sb.append((String)genericObjects.get(i));
                if (i >= genericObjects.size() - 1) continue;
                sb.append(", ");
            }
            sb.append('>');
        }
        return sb.toString();
    }
}

