/*
 * Decompiled with CFR 0.152.
 */
package com.zvoykish.restdl.generator.java.impl;

import com.zvoykish.restdl.generator.ContentGenerator;
import com.zvoykish.restdl.objects.PrimitiveObject;
import com.zvoykish.restdl.objects.TypedObject;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class PrimitiveObjectContentGenerator
implements ContentGenerator<PrimitiveObject> {
    private static final List<Pattern> IGNORED_CLASSES = new ArrayList<Pattern>();

    @Override
    public String generateContent(PrimitiveObject object, String className, Map<Long, TypedObject> typeMap) {
        for (Pattern ignoredClass : IGNORED_CLASSES) {
            if (!ignoredClass.matcher(object.getClassName()).find()) continue;
            return null;
        }
        Template template = Velocity.getTemplate((String)"templates/object_primitive.vm");
        StringWriter stringWriter = new StringWriter();
        VelocityContext context = new VelocityContext();
        context.put("className", (Object)className);
        template.merge((Context)context, (Writer)stringWriter);
        return stringWriter.toString();
    }

    static {
        IGNORED_CLASSES.add(Pattern.compile("(void)|(long)|(int)(boolean)|(float)|(double)|(short)|(byte)"));
        IGNORED_CLASSES.add(Pattern.compile("java..*"));
    }
}

