/*
 * Decompiled with CFR 0.152.
 */
package com.kevin.gridpager;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.PagerAdapter;
import com.kevin.gridpager.GridViewAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0005H\u0016J\b\u0010 \u001a\u00020\u0010H\u0002J\u0012\u0010!\u001a\u00020\u00102\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004J\u0016\u0010\"\u001a\u00020\u00102\u000e\u0010#\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007J\u000e\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\nJ\u0016\u0010&\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\n2\u0006\u0010'\u001a\u00020\nJ\u000e\u0010(\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\nR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/kevin/gridpager/GridPagerAdapter;", "Landroidx/viewpager/widget/PagerAdapter;", "()V", "dataItems", "", "", "gridAdapter", "Lcom/kevin/gridpager/GridViewAdapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "pageColumns", "", "pageRows", "pageSize", "recycledViewPool", "Landroidx/recyclerview/widget/RecyclerView$RecycledViewPool;", "destroyItem", "", "container", "Landroid/view/ViewGroup;", "position", "object", "getCount", "getItemPosition", "getPageData", "", "index", "instantiateItem", "isViewFromObject", "", "view", "Landroid/view/View;", "o", "resetPageSize", "setDataItems", "setGridViewAdapter", "adapter", "setPageColumns", "columns", "setPageColumnsAndRows", "rows", "setPageRows", "RecyclerViewAdapter", "gridpagerview_release"})
public final class GridPagerAdapter
extends PagerAdapter {
    private int pageColumns;
    private int pageRows;
    private int pageSize;
    @NotNull
    private List<Object> dataItems = new ArrayList();
    private GridViewAdapter<Object, RecyclerView.ViewHolder> gridAdapter;
    @NotNull
    private final RecyclerView.RecycledViewPool recycledViewPool = new RecyclerView.RecycledViewPool();

    public final void setPageColumnsAndRows(int columns, int rows) {
        this.pageColumns = columns;
        this.pageRows = rows;
        this.resetPageSize();
    }

    public final void setPageColumns(int columns) {
        this.pageColumns = columns;
        this.resetPageSize();
        this.notifyDataSetChanged();
    }

    public final void setPageRows(int rows) {
        this.pageRows = rows;
        this.resetPageSize();
        this.notifyDataSetChanged();
    }

    private final void resetPageSize() {
        this.pageSize = this.pageColumns * this.pageRows;
        this.recycledViewPool.setMaxRecycledViews(0, this.pageSize * 2);
    }

    public final void setGridViewAdapter(@NotNull GridViewAdapter<?, ?> adapter) {
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        this.gridAdapter = adapter;
    }

    public void destroyItem(@NotNull ViewGroup container, int position, @NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
        container.removeView((View)object);
    }

    public int getCount() {
        return (int)Math.ceil((double)this.dataItems.size() / (double)this.pageSize);
    }

    @NotNull
    public Object instantiateItem(@NotNull ViewGroup container, int position) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Context context = container.getContext();
        RecyclerView view = new RecyclerView(context);
        view.setRecycledViewPool(this.recycledViewPool);
        view.setOverScrollMode(2);
        view.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        view.setHasFixedSize(true);
        GridLayoutManager layoutManager = new GridLayoutManager(context, this.pageColumns);
        layoutManager.setRecycleChildrenOnDetach(true);
        view.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        GridViewAdapter<Object, RecyclerView.ViewHolder> gridViewAdapter = this.gridAdapter;
        if (gridViewAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridAdapter");
            gridViewAdapter = null;
        }
        RecyclerViewAdapter adapter = new RecyclerViewAdapter(this.pageSize * position, gridViewAdapter);
        adapter.setData$gridpagerview_release(this.getPageData(position));
        view.setAdapter((RecyclerView.Adapter)adapter);
        container.addView((View)view);
        return view;
    }

    public boolean isViewFromObject(@NotNull View view, @NotNull Object o) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        return view == o;
    }

    public int getItemPosition(@NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
        return -2;
    }

    public final void setDataItems(@NotNull List<?> dataItems) {
        Intrinsics.checkNotNullParameter(dataItems, (String)"dataItems");
        this.dataItems.clear();
        this.dataItems.addAll(CollectionsKt.filterNotNull((Iterable)dataItems));
        this.notifyDataSetChanged();
    }

    private final List<Object> getPageData(int index) {
        int realIndex = index;
        if (realIndex < 0) {
            realIndex = 0;
        }
        int fromIndex = realIndex * this.pageSize;
        int toIndex = (realIndex + 1) * this.pageSize;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex < 0) {
            toIndex = 0;
        }
        if (fromIndex > this.dataItems.size()) {
            fromIndex = this.dataItems.size();
        }
        if (toIndex > this.dataItems.size()) {
            toIndex = this.dataItems.size();
        }
        return this.dataItems.subList(fromIndex, toIndex);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\u0004H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J\u001b\u0010\u0014\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016H\u0000\u00a2\u0006\u0002\b\u0017R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/kevin/gridpager/GridPagerAdapter$RecyclerViewAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "positionOffset", "", "realAdapter", "Lcom/kevin/gridpager/GridViewAdapter;", "", "(Lcom/kevin/gridpager/GridPagerAdapter;ILcom/kevin/gridpager/GridViewAdapter;)V", "pageDataItems", "", "getItemCount", "onBindViewHolder", "", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setData", "dataList", "", "setData$gridpagerview_release", "gridpagerview_release"})
    private final class RecyclerViewAdapter
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        private final int positionOffset;
        @NotNull
        private final GridViewAdapter<Object, RecyclerView.ViewHolder> realAdapter;
        @NotNull
        private List<Object> pageDataItems;

        public RecyclerViewAdapter(@NotNull int positionOffset, GridViewAdapter<Object, RecyclerView.ViewHolder> realAdapter) {
            Intrinsics.checkNotNullParameter(realAdapter, (String)"realAdapter");
            this.positionOffset = positionOffset;
            this.realAdapter = realAdapter;
            this.pageDataItems = new ArrayList();
        }

        public final void setData$gridpagerview_release(@NotNull List<? extends Object> dataList) {
            Intrinsics.checkNotNullParameter(dataList, (String)"dataList");
            this.pageDataItems.clear();
            this.pageDataItems.addAll((Collection<Object>)dataList);
            this.notifyDataSetChanged();
        }

        @NotNull
        public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            return this.realAdapter.onCreateViewHolder(parent, viewType);
        }

        public void onBindViewHolder(@NotNull RecyclerView.ViewHolder holder, int position) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.realAdapter.onBindViewHolder(holder, this.positionOffset + position, position, this.pageDataItems.get(position));
        }

        public int getItemCount() {
            return this.pageDataItems.size();
        }
    }
}

