/*
 * Decompiled with CFR 0.152.
 */
package com.kevin.slidingtab;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.kevin.slidingtab.R;
import com.kevin.slidingtab.SlidingTabStrip;

public class SlidingTabLayout
extends HorizontalScrollView {
    public static final int MODE_SCROLLABLE = 0;
    public static final int MODE_FIXED = 1;
    @TabMode
    private int mMode;
    private float mLeftPadding;
    private float mRightPadding;
    private int mTabLayoutRes;
    private boolean mIsTabTextBold;
    int mTabPaddingStart;
    int mTabPaddingTop;
    int mTabPaddingEnd;
    int mTabPaddingBottom;
    private int mTabTextColor;
    private int mSelectedTabTextColor;
    private int mTabTextSize;
    private int mTabSelectedTextSize;
    private boolean mSmoothScroll;
    @Nullable
    private ViewPager mViewPager;
    private PagerAdapter mPagerAdapter;
    private SlidingTabStrip mSlidingTabStrip;
    private TabLayoutOnPageChangeListener mPageChangeListener;
    private AdapterChangeListener mAdapterChangeListener;
    private DataSetObserver mPagerAdapterObserver;
    private OnTabCreateListener mOnTabCreateListener;
    private OnTabClickListener mOnTabClickListener;
    private OnSelectedTabClickListener mOnSelectedTabClickListener;
    private OnTabSelectedListener mOnTabSelectedListener;

    public SlidingTabLayout(Context context) {
        this(context, null);
    }

    public SlidingTabLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SlidingTabLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setHorizontalScrollBarEnabled(false);
        this.setFillViewport(true);
        this.mSlidingTabStrip = new SlidingTabStrip(context);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SlidingTabLayout);
        this.mMode = a.getInt(R.styleable.SlidingTabLayout_stl_tabMode, 1);
        this.mLeftPadding = a.getDimension(R.styleable.SlidingTabLayout_stl_leftPadding, 0.0f);
        this.mRightPadding = a.getDimension(R.styleable.SlidingTabLayout_stl_rightPadding, 0.0f);
        this.mSmoothScroll = a.getBoolean(R.styleable.SlidingTabLayout_stl_smoothScroll, true);
        this.mTabLayoutRes = a.getResourceId(R.styleable.SlidingTabLayout_stl_tabLayout, 0);
        this.mTabPaddingEnd = this.mTabPaddingBottom = a.getDimensionPixelSize(R.styleable.SlidingTabLayout_stl_tabPadding, 0);
        this.mTabPaddingTop = this.mTabPaddingBottom;
        this.mTabPaddingStart = this.mTabPaddingBottom;
        this.mTabPaddingStart = a.getDimensionPixelSize(R.styleable.SlidingTabLayout_stl_tabPaddingStart, this.mTabPaddingStart);
        this.mTabPaddingTop = a.getDimensionPixelSize(R.styleable.SlidingTabLayout_stl_tabPaddingTop, this.mTabPaddingTop);
        this.mTabPaddingEnd = a.getDimensionPixelSize(R.styleable.SlidingTabLayout_stl_tabPaddingEnd, this.mTabPaddingEnd);
        this.mTabPaddingBottom = a.getDimensionPixelSize(R.styleable.SlidingTabLayout_stl_tabPaddingBottom, this.mTabPaddingBottom);
        this.mTabTextSize = a.getDimensionPixelSize(R.styleable.SlidingTabLayout_stl_tabTextSize, this.dpToPx(16));
        this.mTabSelectedTextSize = a.getDimensionPixelSize(R.styleable.SlidingTabLayout_stl_tabSelectedTextSize, this.mTabTextSize);
        this.mTabTextColor = a.getColor(R.styleable.SlidingTabLayout_stl_tabTextColor, -7829368);
        this.mSelectedTabTextColor = a.getColor(R.styleable.SlidingTabLayout_stl_tabSelectedTextColor, -12303292);
        this.mIsTabTextBold = a.getBoolean(R.styleable.SlidingTabLayout_stl_tabTextBold, false);
        this.mSlidingTabStrip.setGravity(a.getInt(R.styleable.SlidingTabLayout_stl_tabGravity, 16));
        this.mSlidingTabStrip.setLeftPadding(this.mLeftPadding);
        this.mSlidingTabStrip.setRightPadding(this.mRightPadding);
        this.mSlidingTabStrip.setTabText(this.mTabTextSize, this.mTabTextColor);
        this.mSlidingTabStrip.setTabSelectedText(this.mTabSelectedTextSize, this.mSelectedTabTextColor);
        this.mSlidingTabStrip.setIndicatorCreep(a.getBoolean(R.styleable.SlidingTabLayout_stl_tabIndicatorCreep, false));
        this.mSlidingTabStrip.setIndicatorHeight(a.getDimension(R.styleable.SlidingTabLayout_stl_tabIndicatorHeight, 0.0f));
        this.mSlidingTabStrip.setIndicatorWidth(a.getDimension(R.styleable.SlidingTabLayout_stl_tabIndicatorWidth, 0.0f));
        this.mSlidingTabStrip.setIndicatorWidthRatio(a.getFloat(R.styleable.SlidingTabLayout_stl_tabIndicatorWidthRatio, 1.0f));
        this.mSlidingTabStrip.setIndicatorColor(a.getColor(R.styleable.SlidingTabLayout_stl_tabIndicatorColor, 0));
        this.mSlidingTabStrip.setIndicatorDrawable(a.getDrawable(R.styleable.SlidingTabLayout_stl_tabIndicator));
        this.mSlidingTabStrip.setIndicatorCornerRadius(a.getDimension(R.styleable.SlidingTabLayout_stl_tabIndicatorCornerRadius, 0.0f));
        this.mSlidingTabStrip.setIndicatorTopMargin(a.getDimension(R.styleable.SlidingTabLayout_stl_tabIndicatorMarginTop, 0.0f));
        this.mSlidingTabStrip.setIndicatorBottomMargin(a.getDimension(R.styleable.SlidingTabLayout_stl_tabIndicatorMarginBottom, 0.0f));
        this.mSlidingTabStrip.setIndicatorGravity(a.getInt(R.styleable.SlidingTabLayout_stl_tabIndicatorGravity, 80));
        this.mSlidingTabStrip.setTabTextSelectedBold(a.getBoolean(R.styleable.SlidingTabLayout_stl_tabTextSelectedBold, false));
        this.mSlidingTabStrip.setTabTextBold(this.mIsTabTextBold);
        this.mSlidingTabStrip.setDividerWidth(a.getDimension(R.styleable.SlidingTabLayout_stl_tabDividerWidth, 0.0f));
        this.mSlidingTabStrip.setDividerPadding(a.getDimension(R.styleable.SlidingTabLayout_stl_tabDividerPadding, 0.0f));
        this.mSlidingTabStrip.setDividerColor(a.getColor(R.styleable.SlidingTabLayout_stl_tabDividerColor, this.getAlphaColor(-16777216, (byte)32)));
        this.mSlidingTabStrip.setShowTabTextScaleAnim(a.getBoolean(R.styleable.SlidingTabLayout_stl_tabTextShowScaleAnim, true));
        a.recycle();
        this.addView((View)this.mSlidingTabStrip, -1, -1);
    }

    public void setupWithViewPager(@Nullable ViewPager viewPager) {
        if (this.mViewPager != null) {
            if (this.mPageChangeListener != null) {
                this.mViewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this.mPageChangeListener);
            }
            if (this.mAdapterChangeListener != null) {
                this.mViewPager.removeOnAdapterChangeListener((ViewPager.OnAdapterChangeListener)this.mAdapterChangeListener);
            }
        }
        if (viewPager != null) {
            this.mViewPager = viewPager;
            if (this.mPageChangeListener == null) {
                this.mPageChangeListener = new TabLayoutOnPageChangeListener(this);
            }
            viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.mPageChangeListener);
            PagerAdapter adapter = viewPager.getAdapter();
            if (adapter != null) {
                this.setPagerAdapter(adapter);
            }
            if (this.mAdapterChangeListener == null) {
                this.mAdapterChangeListener = new AdapterChangeListener();
            }
            viewPager.addOnAdapterChangeListener((ViewPager.OnAdapterChangeListener)this.mAdapterChangeListener);
        }
    }

    @Nullable
    public ViewPager getViewPager() {
        return this.mViewPager;
    }

    public void setTabMode(@TabMode int mode) {
        if (this.mMode != mode) {
            this.mMode = mode;
            this.setupWithViewPager(this.mViewPager);
        }
    }

    @TabMode
    int getTabMode() {
        return this.mMode;
    }

    int getTabLayoutRes() {
        return this.mTabLayoutRes;
    }

    void setTabTextBold(boolean mIsTabTextBold) {
        this.mIsTabTextBold = mIsTabTextBold;
    }

    private void setPagerAdapter(PagerAdapter adapter) {
        if (this.mPagerAdapter != null && this.mPagerAdapterObserver != null) {
            this.mPagerAdapter.unregisterDataSetObserver(this.mPagerAdapterObserver);
        }
        this.mPagerAdapter = adapter;
        if (adapter != null) {
            if (this.mPagerAdapterObserver == null) {
                this.mPagerAdapterObserver = new PagerAdapterObserver();
            }
            adapter.registerDataSetObserver(this.mPagerAdapterObserver);
        }
        this.populateFromPagerAdapter();
    }

    private void populateFromPagerAdapter() {
        int curItem;
        if (this.mViewPager == null) {
            return;
        }
        PagerAdapter adapter = this.mViewPager.getAdapter();
        if (adapter == null) {
            return;
        }
        this.mSlidingTabStrip.reset();
        TabClickListener listener = new TabClickListener(this);
        for (int i = 0; i < adapter.getCount(); ++i) {
            TextView view = null;
            TextView textView = null;
            ImageView iconView = null;
            if (this.mTabLayoutRes != 0) {
                view = LayoutInflater.from((Context)this.getContext()).inflate(this.mTabLayoutRes, (ViewGroup)this.mSlidingTabStrip, false);
                textView = (TextView)view.findViewById(R.id.sliding_tab_text);
                iconView = (ImageView)view.findViewById(R.id.sliding_tab_icon);
                if (textView != null && textView.getTypeface() != null) {
                    this.mIsTabTextBold = textView.getTypeface().isBold();
                    this.mSlidingTabStrip.setTabTextBold(this.mIsTabTextBold);
                }
                if (adapter instanceof SlidingTabPageAdapter && iconView != null) {
                    Drawable drawable = ((SlidingTabPageAdapter)adapter).getDrawable(i);
                    if (drawable != null) {
                        iconView.setImageDrawable(drawable);
                    } else {
                        iconView.setVisibility(8);
                    }
                }
            }
            if (textView == null && view instanceof TextView) {
                textView = view;
            }
            if (textView == null) {
                textView = new TextView(this.getContext());
            }
            if (view == null) {
                view = textView;
            }
            textView.setText(adapter.getPageTitle(i));
            view.setOnClickListener((View.OnClickListener)listener);
            this.setLayoutParams((View)view, i, adapter.getCount());
            this.mSlidingTabStrip.addView((View)view);
        }
        if (this.mViewPager != null && this.mPagerAdapter != null && this.mPagerAdapter.getCount() > 0 && (curItem = this.mViewPager.getCurrentItem()) != this.mSlidingTabStrip.getSelectedPosition()) {
            this.mSlidingTabStrip.setTabSelected(true);
            this.mSlidingTabStrip.setSelectedPosition(curItem);
        }
        if (this.mOnTabCreateListener != null) {
            this.mOnTabCreateListener.onCreated();
        }
    }

    private int getAlphaColor(int color, byte alpha) {
        return Color.argb((int)alpha, (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color));
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mViewPager != null) {
            this.scrollToSelectedTab(this.mViewPager.getCurrentItem(), 0.0f);
            if (this.getOnTabSelectedListener() != null) {
                this.getOnTabSelectedListener().onSelected(this.mViewPager.getCurrentItem());
            }
        }
    }

    public void setSmoothScroll(boolean smoothScroll) {
        this.mSmoothScroll = smoothScroll;
    }

    public boolean getSmoothScroll() {
        return this.mSmoothScroll;
    }

    public void setTextColor(@ColorInt int color) {
        this.mTabTextColor = color;
        this.mSlidingTabStrip.setTabText(this.mTabTextSize, color);
        this.mSlidingTabStrip.invalidate();
    }

    public void setSelectedTextColor(@ColorInt int color) {
        this.mSelectedTabTextColor = color;
        this.mSlidingTabStrip.setTabSelectedText(this.mTabSelectedTextSize, color);
    }

    public void setSelectedTextColors(int ... colors) {
        this.mSlidingTabStrip.setTabSelectedText(this.mTabSelectedTextSize, colors);
    }

    public void setDividerColors(int ... colors) {
        this.mSlidingTabStrip.setDividerColors(colors);
    }

    public void setCustomTabPalette(TabPalette tabPalette) {
        this.mSlidingTabStrip.setCustomTabPalette(tabPalette);
    }

    SlidingTabStrip getSlidingTabStrip() {
        return this.mSlidingTabStrip;
    }

    public View getTabAt(int index) {
        return this.mSlidingTabStrip.getChildAt(index);
    }

    public void setOnTabCreatedListener(OnTabCreateListener listener) {
        this.mOnTabCreateListener = listener;
    }

    public OnTabCreateListener getOnTabCreatedListener() {
        return this.mOnTabCreateListener;
    }

    public void setOnSelectedTabClickListener(@Nullable OnSelectedTabClickListener listener) {
        this.mOnSelectedTabClickListener = listener;
    }

    public OnSelectedTabClickListener getOnSelectedTabClickListener() {
        return this.mOnSelectedTabClickListener;
    }

    public void setOnTabClickListener(@Nullable OnTabClickListener listener) {
        this.mOnTabClickListener = listener;
    }

    public OnTabClickListener getOnTabClickListener() {
        return this.mOnTabClickListener;
    }

    public void setOnTabSelectedListener(@Nullable OnTabSelectedListener listener) {
        this.mOnTabSelectedListener = listener;
    }

    public OnTabSelectedListener getOnTabSelectedListener() {
        return this.mOnTabSelectedListener;
    }

    public void setOnColorChangedListener(OnColorChangeListener listener) {
        this.mSlidingTabStrip.setOnColorChangeListener(listener);
    }

    void setLayoutParams(View view, int position, int count) {
        view.setPadding(this.mTabPaddingStart, this.mTabPaddingTop, this.mTabPaddingEnd, this.mTabPaddingBottom);
        TextView text = view instanceof TextView ? (TextView)view : (TextView)view.findViewById(R.id.sliding_tab_text);
        text.setGravity(17);
        text.setTextSize(0, (float)this.mTabTextSize);
        text.setTextColor(this.mTabTextColor);
        text.setTypeface(Typeface.create((Typeface)text.getTypeface(), (int)(this.mIsTabTextBold ? 1 : 0)));
        LinearLayout.LayoutParams layoutParams = this.mMode == 1 ? new LinearLayout.LayoutParams(0, -2, 1.0f) : new LinearLayout.LayoutParams(-2, -2, 0.0f);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (position == 0 && this.mLeftPadding > 0.0f) {
            view.setPadding((int)this.mLeftPadding + this.mTabPaddingStart, this.mTabPaddingTop, this.mTabPaddingEnd, this.mTabPaddingBottom);
        }
        if (position == count - 1 && this.mRightPadding > 0.0f) {
            view.setPadding(this.mTabPaddingStart, this.mTabPaddingTop, (int)this.mRightPadding + this.mTabPaddingEnd, this.mTabPaddingBottom);
        }
    }

    void scrollToSelectedTab(int firstPagePosition, float positionOffset) {
        int childCount = this.mSlidingTabStrip.getChildCount();
        if (childCount == 0) {
            return;
        }
        View firstPageTabView = this.mSlidingTabStrip.getChildAt(firstPagePosition);
        float offset = (float)firstPageTabView.getWidth() * positionOffset;
        float scrollX = (float)(this.getPaddingLeft() + firstPageTabView.getLeft()) + offset - (float)(this.getWidth() / 2);
        float left = 0.0f;
        float right = 0.0f;
        if (firstPagePosition < childCount - 1) {
            View secondPageTabView = this.mSlidingTabStrip.getChildAt(firstPagePosition + 1);
            left = (float)firstPageTabView.getLeft() + positionOffset * (float)(secondPageTabView.getLeft() - firstPageTabView.getLeft());
            right = (float)firstPageTabView.getRight() + positionOffset * (float)(secondPageTabView.getRight() - firstPageTabView.getRight());
        } else if (firstPagePosition == childCount - 1) {
            left = firstPageTabView.getLeft();
            right = firstPageTabView.getRight();
        }
        this.scrollTo((int)(scrollX += (right - left) / 2.0f), 0);
    }

    int dpToPx(int dps) {
        return Math.round(this.getResources().getDisplayMetrics().density * (float)dps);
    }

    public static interface OnTabSelectedListener {
        public void onSelected(int var1);
    }

    public static interface OnSelectedTabClickListener {
        public void onClick(int var1);
    }

    public static interface OnTabClickListener {
        public void onClick(int var1);
    }

    public static interface OnColorChangeListener {
        public void onColorChanged(@ColorInt int var1);
    }

    public static interface OnTabCreateListener {
        public void onCreated();
    }

    public static interface TabPalette {
        public int getTextColor(int var1);

        public int getDividerColor(int var1);
    }

    public static abstract class SlidingTabPageAdapter
    extends FragmentPagerAdapter {
        public SlidingTabPageAdapter(FragmentManager fm) {
            super(fm);
        }

        public abstract Drawable getDrawable(int var1);
    }

    private class PagerAdapterObserver
    extends DataSetObserver {
        PagerAdapterObserver() {
        }

        public void onChanged() {
            SlidingTabLayout.this.populateFromPagerAdapter();
        }

        public void onInvalidated() {
            SlidingTabLayout.this.populateFromPagerAdapter();
        }
    }

    private class TabClickListener
    implements View.OnClickListener {
        private final SlidingTabLayout mTabLayout;

        TabClickListener(SlidingTabLayout tabLayout) {
            this.mTabLayout = tabLayout;
        }

        public void onClick(View view) {
            for (int i = 0; i < this.mTabLayout.getSlidingTabStrip().getChildCount(); ++i) {
                ViewPager viewPager;
                if (view != this.mTabLayout.getSlidingTabStrip().getChildAt(i)) continue;
                this.mTabLayout.getSlidingTabStrip().setTabSelected(true);
                if (this.mTabLayout.getOnTabClickListener() != null) {
                    this.mTabLayout.getOnTabClickListener().onClick(i);
                }
                if ((viewPager = this.mTabLayout.getViewPager()) != null && viewPager.getCurrentItem() == i && this.mTabLayout.getOnSelectedTabClickListener() != null) {
                    this.mTabLayout.getOnSelectedTabClickListener().onClick(i);
                }
                if (viewPager == null) break;
                viewPager.setCurrentItem(i, SlidingTabLayout.this.mSmoothScroll);
                break;
            }
        }
    }

    private class AdapterChangeListener
    implements ViewPager.OnAdapterChangeListener {
        AdapterChangeListener() {
        }

        public void onAdapterChanged(@NonNull ViewPager viewPager, @Nullable PagerAdapter oldAdapter, @Nullable PagerAdapter newAdapter) {
            if (SlidingTabLayout.this.mViewPager == viewPager) {
                SlidingTabLayout.this.setPagerAdapter(newAdapter);
            }
        }
    }

    static class TabLayoutOnPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private final SlidingTabLayout mTabLayout;

        public TabLayoutOnPageChangeListener(SlidingTabLayout tabLayout) {
            this.mTabLayout = tabLayout;
        }

        public void onPageScrollStateChanged(int state) {
            if (state != 0) {
                this.mTabLayout.getSlidingTabStrip().setTabSelected(false);
            }
        }

        public void onPageScrolled(int position, float positionOffset, @Px int positionOffsetPixels) {
            int childCount = this.mTabLayout.getSlidingTabStrip().getChildCount();
            if (position >= 0 && position < childCount) {
                this.mTabLayout.getSlidingTabStrip().setFirstPagePosition(position, positionOffset);
                this.mTabLayout.scrollToSelectedTab(position, positionOffset);
            }
        }

        public void onPageSelected(int position) {
            this.mTabLayout.getSlidingTabStrip().setTabSelected(true);
            this.mTabLayout.getSlidingTabStrip().setSelectedPosition(position);
            if (this.mTabLayout.getOnTabSelectedListener() != null) {
                this.mTabLayout.getOnTabSelectedListener().onSelected(position);
            }
        }
    }

    public static @interface TabMode {
    }
}

