/*
 * Decompiled with CFR 0.152.
 */
package com.kevin.slidingtab;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import com.kevin.slidingtab.R;
import com.kevin.slidingtab.SlidingTabLayout;

final class SlidingTabStrip
extends LinearLayout {
    private static final int ANIMATION_DURATION = 300;
    private float mLeftPadding;
    private float mRightPadding;
    private boolean mIsTabSelected;
    private boolean mIsTabTextBold;
    private boolean mIsTabTextSelectedBold;
    private boolean mShowTabTextScaleAnim;
    private int mFirstPagePosition;
    private float mFirstPagePositionOffset;
    private int mTabTextColor;
    private float mTabTextSize;
    private float mSelectedTabTextSize;
    private int mLastSelectedPosition;
    private int mSelectedPosition;
    private float mDividerWidth;
    private float mDividerPadding;
    private final Paint mDividerPaint;
    private boolean mIndicatorCreep;
    private float mIndicatorHeight;
    private float mIndicatorWidth;
    private float mIndicatorWidthRatio;
    private int mIndicatorColor;
    private Drawable mIndicatorDrawable;
    private float mIndicatorCornerRadius;
    private float mIndicatorTopMargin;
    private float mIndicatorBottomMargin;
    private int mIndicatorGravity;
    private final Paint mIndicatorPaint;
    private final RectF mIndicatorRectF;
    private AccelerateInterpolator mLeftInterpolator;
    private DecelerateInterpolator mRightInterpolator;
    private SlidingTabLayout.TabPalette mCustomTabPalette;
    private final SimpleTabPalette mTabPalette;
    private SlidingTabLayout.OnColorChangeListener mOnColorChangeListener;

    SlidingTabStrip(Context context) {
        super(context);
        this.setWillNotDraw(false);
        this.mTabTextColor = -7829368;
        this.mLastSelectedPosition = -1;
        this.mSelectedPosition = 0;
        this.mIsTabSelected = true;
        this.mLeftInterpolator = new AccelerateInterpolator();
        this.mRightInterpolator = new DecelerateInterpolator();
        this.mTabPalette = new SimpleTabPalette();
        this.mTabPalette.setTextColors(-12303292);
        this.mIndicatorPaint = new Paint();
        this.mDividerPaint = new Paint();
        this.mDividerPaint.setStrokeWidth(this.mDividerWidth);
        this.mIndicatorRectF = new RectF();
    }

    void setLeftPadding(float leftPadding) {
        this.mLeftPadding = leftPadding;
    }

    void setRightPadding(float rightPadding) {
        this.mRightPadding = rightPadding;
    }

    void setIndicatorCreep(boolean creep) {
        this.mIndicatorCreep = creep;
    }

    void setIndicatorHeight(float height) {
        this.mIndicatorHeight = height;
    }

    void setIndicatorWidth(float width) {
        this.mIndicatorWidth = width;
    }

    void setIndicatorWidthRatio(float widthRatio) {
        this.mIndicatorWidthRatio = widthRatio;
    }

    void setIndicatorColor(int color) {
        this.mIndicatorColor = color;
    }

    void setIndicatorDrawable(Drawable drawable) {
        this.mIndicatorDrawable = drawable;
    }

    void setIndicatorCornerRadius(float cornerRadius) {
        this.mIndicatorCornerRadius = cornerRadius;
    }

    void setIndicatorTopMargin(float topMargin) {
        this.mIndicatorTopMargin = topMargin;
    }

    void setIndicatorBottomMargin(float bottomMargin) {
        this.mIndicatorBottomMargin = bottomMargin;
    }

    void setIndicatorGravity(int gravity) {
        this.mIndicatorGravity = gravity;
    }

    void setTabTextSelectedBold(boolean selectedBold) {
        this.mIsTabTextSelectedBold = selectedBold;
    }

    void setDividerWidth(float width) {
        this.mDividerWidth = width;
    }

    void setDividerPadding(float padding) {
        this.mDividerPadding = padding;
    }

    void setDividerColor(int color) {
        this.mTabPalette.setDividerColors(color);
    }

    void setShowTabTextScaleAnim(boolean scaleAnim) {
        this.mShowTabTextScaleAnim = scaleAnim;
    }

    void setTabSelected(boolean mIsTabSelected) {
        this.mIsTabSelected = mIsTabSelected;
    }

    private int mixColor(int firstColor, int secondColor, float ratio) {
        return Color.argb((int)((int)((float)Color.alpha((int)firstColor) * ratio + (float)Color.alpha((int)secondColor) * (1.0f - ratio))), (int)((int)((float)Color.red((int)firstColor) * ratio + (float)Color.red((int)secondColor) * (1.0f - ratio))), (int)((int)((float)Color.green((int)firstColor) * ratio + (float)Color.green((int)secondColor) * (1.0f - ratio))), (int)((int)((float)Color.blue((int)firstColor) * ratio + (float)Color.blue((int)secondColor) * (1.0f - ratio))));
    }

    private void setTabTextSize(int index, final float size, boolean showAnim) {
        if (index < 0 || index >= this.getChildCount()) {
            return;
        }
        final TextView text = this.getTextView(index);
        if (showAnim) {
            final ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{text.getTextSize(), size});
            animator.setDuration(300L);
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator paramAnonymousValueAnimator) {
                    float f = ((Float)paramAnonymousValueAnimator.getAnimatedValue()).floatValue();
                    text.setTextSize(0, f);
                    if (f == size) {
                        animator.removeUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
                    }
                }
            });
            animator.start();
        } else {
            text.setTextSize(0, size);
        }
    }

    private void setTabTextSelected(int index, boolean selected) {
        if (index < 0 || index >= this.getChildCount()) {
            return;
        }
        TextView text = this.getTextView(index);
        text.setSelected(selected);
    }

    private void setTabTextColor(int index, @ColorInt int color) {
        if (index < 0 || index >= this.getChildCount()) {
            return;
        }
        this.getTextView(index).setTextColor(color);
    }

    private void setTabTextTypeface(int index, int style) {
        if (index < 0 || index >= this.getChildCount()) {
            return;
        }
        TextView text = this.getTextView(index);
        text.setTypeface(Typeface.create((Typeface)text.getTypeface(), (int)style));
    }

    private boolean onlySelectedTabBold() {
        return !this.mIsTabTextBold && this.mIsTabTextSelectedBold;
    }

    void setTabText(float titleTextSize, @ColorInt int defaultTabTextColor) {
        this.mTabTextSize = titleTextSize;
        this.mTabTextColor = defaultTabTextColor;
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (i != this.mSelectedPosition) {
                TextView text = this.getTextView(i);
                text.setTextColor(this.mTabTextColor);
                text.setTextSize(0, titleTextSize);
                if (this.onlySelectedTabBold() && this.mLastSelectedPosition != -1) {
                    this.setTabTextTypeface(this.mLastSelectedPosition, 0);
                }
                text.invalidate();
                continue;
            }
            if (!this.onlySelectedTabBold() || this.mLastSelectedPosition == -1) continue;
            this.setTabTextTypeface(this.mLastSelectedPosition, 1);
        }
    }

    void setTabSelectedText(float selectedTabTextSize, int ... colors) {
        this.mSelectedTabTextSize = selectedTabTextSize;
        if (this.mShowTabTextScaleAnim) {
            this.mShowTabTextScaleAnim = this.mSelectedTabTextSize != this.mTabTextSize;
        }
        this.mCustomTabPalette = null;
        this.mTabPalette.setTextColors(colors);
        this.invalidate();
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (i == this.mSelectedPosition) {
                TextView text = this.getTextView(i);
                text.setTextColor(colors[this.mSelectedPosition % colors.length]);
                text.setTextSize(0, selectedTabTextSize);
                if (this.onlySelectedTabBold() && this.mLastSelectedPosition != -1) {
                    this.setTabTextTypeface(this.mLastSelectedPosition, 1);
                }
                text.invalidate();
                continue;
            }
            if (!this.onlySelectedTabBold() || this.mLastSelectedPosition == -1) continue;
            this.setTabTextTypeface(this.mLastSelectedPosition, 0);
        }
    }

    public void setTabTextBold(boolean tabTextBold) {
        this.mIsTabTextBold = tabTextBold;
    }

    public int getSelectedPosition() {
        return this.mSelectedPosition;
    }

    void setSelectedPosition(int position) {
        this.mSelectedPosition = position;
        this.invalidate();
    }

    void setFirstPagePosition(int position, float positionOffset) {
        this.mFirstPagePosition = position;
        this.mFirstPagePositionOffset = positionOffset;
        this.invalidate();
    }

    void setCustomTabPalette(SlidingTabLayout.TabPalette tabPalette) {
        this.mCustomTabPalette = tabPalette;
        this.invalidate();
    }

    void setDividerColors(int ... colors) {
        this.mCustomTabPalette = null;
        this.mTabPalette.setDividerColors(colors);
        this.invalidate();
    }

    private TextView getTextView(int index) {
        View text = this.getChildAt(index);
        if (!(text instanceof TextView)) {
            text = text.findViewById(R.id.sliding_tab_text);
        }
        return (TextView)text;
    }

    void setOnColorChangeListener(SlidingTabLayout.OnColorChangeListener listener) {
        this.mOnColorChangeListener = listener;
    }

    protected void onDraw(Canvas canvas) {
        SlidingTabLayout.TabPalette tabPalette;
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return;
        }
        SlidingTabLayout.TabPalette tabPalette2 = tabPalette = this.mCustomTabPalette != null ? this.mCustomTabPalette : this.mTabPalette;
        if (this.mLastSelectedPosition != this.mSelectedPosition) {
            if (this.mTabTextSize != this.mSelectedTabTextSize) {
                this.setTabTextSize(this.mSelectedPosition, this.mSelectedTabTextSize, this.mShowTabTextScaleAnim);
                this.setTabTextSize(this.mLastSelectedPosition, this.mTabTextSize, this.mShowTabTextScaleAnim);
            }
            if (this.onlySelectedTabBold()) {
                this.setTabTextTypeface(this.mSelectedPosition, 1);
                this.setTabTextTypeface(this.mLastSelectedPosition, 0);
            }
            if (this.mIsTabSelected) {
                this.setTabTextColor(this.mSelectedPosition, tabPalette.getTextColor(this.mSelectedPosition));
                this.setTabTextColor(this.mLastSelectedPosition, this.mTabTextColor);
                this.setTabTextSelected(this.mSelectedPosition, true);
                this.setTabTextSelected(this.mLastSelectedPosition, false);
            }
            this.mLastSelectedPosition = this.mSelectedPosition;
        }
        int secondPagePosition = this.mFirstPagePosition + 1;
        if (!this.mIsTabSelected) {
            this.setTabTextColor(this.mFirstPagePosition, this.mixColor(this.mTabTextColor, tabPalette.getTextColor(this.mFirstPagePosition), this.mFirstPagePositionOffset));
            if (this.mFirstPagePositionOffset > 0.0f && this.mFirstPagePosition < this.getChildCount() - 1) {
                this.setTabTextColor(secondPagePosition, this.mixColor(tabPalette.getTextColor(secondPagePosition), this.mTabTextColor, this.mFirstPagePositionOffset));
            }
        }
        if (this.mDividerWidth > 0.0f) {
            int dividerHeight = this.mDividerPadding == 0.0f ? this.getHeight() / 2 : (int)((float)this.getHeight() - 2.0f * this.mDividerPadding);
            for (int i = 0; i < childCount - 1; ++i) {
                View childView = this.getChildAt(i);
                this.mDividerPaint.setColor(tabPalette.getDividerColor(i));
                canvas.drawLine((float)childView.getRight(), (float)(this.getHeight() - dividerHeight) / 2.0f, (float)childView.getRight(), (float)(this.getHeight() + dividerHeight) / 2.0f, this.mDividerPaint);
            }
        }
        if (this.mIndicatorHeight > 0.0f) {
            View firstPageTabView = this.getChildAt(this.mFirstPagePosition);
            float firstPageTabLeft = firstPageTabView.getLeft();
            float firstPageTabRight = firstPageTabView.getRight();
            if (this.mFirstPagePosition == 0 && this.mLeftPadding > 0.0f) {
                firstPageTabLeft += this.mLeftPadding;
            }
            float indicatorRectFLeft = 0.0f;
            float indicatorRectFRight = 0.0f;
            int firstPageTextColor = tabPalette.getTextColor(this.mFirstPagePosition);
            if (this.mFirstPagePosition < this.getChildCount() - 1) {
                View secondPageTabView = this.getChildAt(secondPagePosition);
                int secondPageTextColor = tabPalette.getTextColor(secondPagePosition);
                if (firstPageTextColor != secondPageTextColor) {
                    firstPageTextColor = this.mixColor(secondPageTextColor, firstPageTextColor, this.mFirstPagePositionOffset);
                }
                float secondPageTabLeft = secondPageTabView.getLeft();
                float secondPageTabRight = secondPageTabView.getRight();
                if (secondPagePosition == this.getChildCount() - 1) {
                    secondPageTabRight -= this.mRightPadding;
                }
                if (this.mIndicatorWidth != 0.0f) {
                    float firstMiddle = (firstPageTabLeft + firstPageTabRight) / 2.0f;
                    firstPageTabLeft = firstMiddle - this.mIndicatorWidth / 2.0f;
                    firstPageTabRight = firstMiddle + this.mIndicatorWidth / 2.0f;
                    float secondMiddle = (secondPageTabLeft + secondPageTabRight) / 2.0f;
                    secondPageTabLeft = secondMiddle - this.mIndicatorWidth / 2.0f;
                    secondPageTabRight = secondMiddle + this.mIndicatorWidth / 2.0f;
                } else if (this.mIndicatorWidthRatio > 0.0f && this.mIndicatorWidthRatio < 1.0f) {
                    float firstMiddle = (firstPageTabLeft + firstPageTabRight) / 2.0f;
                    firstPageTabLeft = firstMiddle - (firstPageTabRight - firstPageTabLeft) / 2.0f * this.mIndicatorWidthRatio;
                    firstPageTabRight = firstMiddle + (firstPageTabRight - firstPageTabLeft) / 2.0f * this.mIndicatorWidthRatio;
                    float secondMiddle = (secondPageTabLeft + secondPageTabRight) / 2.0f;
                    secondPageTabLeft = secondMiddle - (secondPageTabRight - secondPageTabLeft) / 2.0f * this.mIndicatorWidthRatio;
                    secondPageTabRight = secondMiddle + (secondPageTabRight - secondPageTabLeft) / 2.0f * this.mIndicatorWidthRatio;
                }
                if (!this.mIndicatorCreep) {
                    indicatorRectFLeft = firstPageTabLeft + this.mFirstPagePositionOffset * (secondPageTabLeft - firstPageTabLeft);
                    indicatorRectFRight = firstPageTabRight + this.mFirstPagePositionOffset * (secondPageTabRight - firstPageTabRight);
                } else {
                    indicatorRectFLeft = firstPageTabLeft * (1.0f - this.mLeftInterpolator.getInterpolation(this.mFirstPagePositionOffset)) + secondPageTabLeft * this.mLeftInterpolator.getInterpolation(this.mFirstPagePositionOffset);
                    indicatorRectFRight = firstPageTabRight * (1.0f - this.mRightInterpolator.getInterpolation(this.mFirstPagePositionOffset)) + secondPageTabRight * this.mRightInterpolator.getInterpolation(this.mFirstPagePositionOffset);
                }
            } else if (this.mFirstPagePosition == this.getChildCount() - 1) {
                float firstMiddle;
                firstPageTabRight -= this.mRightPadding;
                if (this.mIndicatorWidth != 0.0f) {
                    firstMiddle = (firstPageTabLeft + firstPageTabRight) / 2.0f;
                    firstPageTabLeft = firstMiddle - this.mIndicatorWidth / 2.0f;
                    firstPageTabRight = firstMiddle + this.mIndicatorWidth / 2.0f;
                } else if (this.mIndicatorWidthRatio > 0.0f && this.mIndicatorWidthRatio < 1.0f) {
                    firstMiddle = (firstPageTabLeft + firstPageTabRight) / 2.0f;
                    firstPageTabLeft = firstMiddle - (firstPageTabRight - firstPageTabLeft) / 2.0f * this.mIndicatorWidthRatio;
                    firstPageTabRight = firstMiddle + (firstPageTabRight - firstPageTabLeft) / 2.0f * this.mIndicatorWidthRatio;
                }
                indicatorRectFLeft = firstPageTabLeft;
                indicatorRectFRight = firstPageTabRight;
            }
            int indicatorColor = this.mIndicatorColor == 0 ? firstPageTextColor : this.mIndicatorColor;
            this.mIndicatorPaint.setColor(indicatorColor);
            switch (this.mIndicatorGravity) {
                case 48: {
                    this.mIndicatorRectF.set(indicatorRectFLeft, this.mIndicatorTopMargin, indicatorRectFRight, this.mIndicatorTopMargin + this.mIndicatorHeight);
                    break;
                }
                case 17: {
                    this.mIndicatorRectF.set(indicatorRectFLeft, ((float)this.getHeight() - this.mIndicatorHeight) / 2.0f, indicatorRectFRight, ((float)this.getHeight() + this.mIndicatorHeight) / 2.0f);
                    break;
                }
                case 80: {
                    this.mIndicatorRectF.set(indicatorRectFLeft, (float)this.getHeight() - this.mIndicatorHeight - this.mIndicatorBottomMargin, indicatorRectFRight, (float)this.getHeight() - this.mIndicatorBottomMargin);
                    break;
                }
            }
            if (this.mIndicatorDrawable != null) {
                this.mIndicatorDrawable.setBounds((int)this.mIndicatorRectF.left, (int)this.mIndicatorRectF.top, (int)this.mIndicatorRectF.right, (int)this.mIndicatorRectF.bottom);
                this.mIndicatorDrawable.draw(canvas);
            } else {
                canvas.drawRoundRect(this.mIndicatorRectF, this.mIndicatorCornerRadius, this.mIndicatorCornerRadius, this.mIndicatorPaint);
            }
        }
        if (this.mOnColorChangeListener != null) {
            int secondPageTextColor;
            int firstPageTextColor = tabPalette.getTextColor(this.mFirstPagePosition);
            if (this.mFirstPagePosition < this.getChildCount() - 1 && firstPageTextColor != (secondPageTextColor = tabPalette.getTextColor(secondPagePosition))) {
                firstPageTextColor = this.mixColor(secondPageTextColor, firstPageTextColor, this.mFirstPagePositionOffset);
            }
            this.mOnColorChangeListener.onColorChanged(firstPageTextColor);
        }
    }

    void reset() {
        this.removeAllViews();
        this.mLastSelectedPosition = -1;
        this.mSelectedPosition = 0;
        this.mIsTabSelected = true;
    }

    private static class SimpleTabPalette
    implements SlidingTabLayout.TabPalette {
        private int[] mTextColors;
        private int[] mDividerColors;

        private SimpleTabPalette() {
        }

        public void setTextColors(int ... colors) {
            this.mTextColors = colors;
        }

        @Override
        public final int getTextColor(int position) {
            return this.mTextColors[position % this.mTextColors.length];
        }

        public void setDividerColors(int ... colors) {
            this.mDividerColors = colors;
        }

        @Override
        public final int getDividerColor(int position) {
            return this.mDividerColors[position % this.mDividerColors.length];
        }
    }
}

