/*
 * Decompiled with CFR 0.152.
 */
package com.kevin.slidingtab;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.lifecycle.Lifecycle;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.adapter.FragmentStateAdapter;
import androidx.viewpager2.widget.ViewPager2;
import com.kevin.slidingtab.R;
import com.kevin.slidingtab.SlidingTabLayout;
import java.lang.ref.WeakReference;

public class SlidingTabLayoutMediator {
    @NonNull
    private final SlidingTabLayout tabLayout;
    @NonNull
    private final ViewPager2 viewPager;
    @Nullable
    private SlidingTabPageAdapter adapter;
    private boolean attached;
    @Nullable
    private TabLayoutOnPageChangeCallback onPageChangeCallback;
    @Nullable
    private SlidingTabLayout.OnTabSelectedListener onTabSelectedListener;
    @Nullable
    private RecyclerView.AdapterDataObserver pagerAdapterObserver;

    public SlidingTabLayoutMediator(@NonNull SlidingTabLayout tabLayout, @NonNull ViewPager2 viewPager) {
        this(tabLayout, viewPager, true);
    }

    public SlidingTabLayoutMediator(@NonNull SlidingTabLayout tabLayout, @NonNull ViewPager2 viewPager, boolean smoothScroll) {
        this.tabLayout = tabLayout;
        this.viewPager = viewPager;
        tabLayout.setSmoothScroll(smoothScroll);
    }

    public void attach() {
        if (this.attached) {
            throw new IllegalStateException("TabLayoutMediator is already attached");
        }
        this.adapter = (SlidingTabPageAdapter)this.viewPager.getAdapter();
        if (this.adapter == null) {
            throw new IllegalStateException("TabLayoutMediator attached before ViewPager2 has an adapter");
        }
        this.attached = true;
        this.onPageChangeCallback = new TabLayoutOnPageChangeCallback(this.tabLayout);
        this.viewPager.registerOnPageChangeCallback((ViewPager2.OnPageChangeCallback)this.onPageChangeCallback);
        this.onTabSelectedListener = new ViewPagerOnTabSelectedListener(this.viewPager, this.tabLayout.getSmoothScroll());
        this.tabLayout.setOnTabSelectedListener(this.onTabSelectedListener);
        this.pagerAdapterObserver = new PagerAdapterObserver();
        this.adapter.registerAdapterDataObserver(this.pagerAdapterObserver);
        this.populateTabsFromPagerAdapter();
    }

    public void detach() {
        if (this.adapter != null) {
            this.adapter.unregisterAdapterDataObserver(this.pagerAdapterObserver);
            this.pagerAdapterObserver = null;
        }
        this.tabLayout.setOnTabSelectedListener(null);
        this.viewPager.unregisterOnPageChangeCallback((ViewPager2.OnPageChangeCallback)this.onPageChangeCallback);
        this.onTabSelectedListener = null;
        this.onPageChangeCallback = null;
        this.adapter = null;
        this.attached = false;
    }

    public boolean isAttached() {
        return this.attached;
    }

    void populateTabsFromPagerAdapter() {
        int curItem;
        if (this.adapter == null) {
            return;
        }
        this.tabLayout.getSlidingTabStrip().reset();
        TabClickListener listener = new TabClickListener(this.tabLayout);
        for (int i = 0; i < this.adapter.getItemCount(); ++i) {
            TextView view = null;
            TextView text = null;
            ImageView image = null;
            if (this.tabLayout.getTabLayoutRes() != 0) {
                view = LayoutInflater.from((Context)this.tabLayout.getContext()).inflate(this.tabLayout.getTabLayoutRes(), (ViewGroup)this.tabLayout.getSlidingTabStrip(), false);
                text = (TextView)view.findViewById(R.id.sliding_tab_text);
                image = (ImageView)view.findViewById(R.id.sliding_tab_icon);
                if (text != null && text.getTypeface() != null) {
                    boolean isTabTextBold = text.getTypeface().isBold();
                    this.tabLayout.getSlidingTabStrip().setTabTextBold(isTabTextBold);
                    this.tabLayout.setTabTextBold(isTabTextBold);
                }
                if (image != null) {
                    Drawable drawable = this.adapter.getDrawable(i);
                    if (drawable != null) {
                        image.setImageDrawable(drawable);
                    } else {
                        image.setVisibility(8);
                    }
                }
            }
            if (text == null && view instanceof TextView) {
                text = view;
            }
            if (text == null) {
                text = new TextView(this.tabLayout.getContext());
            }
            if (view == null) {
                view = text;
            }
            text.setText(this.adapter.getPageTitle(i));
            view.setOnClickListener((View.OnClickListener)listener);
            this.tabLayout.setLayoutParams((View)view, i, this.adapter.getItemCount());
            this.tabLayout.getSlidingTabStrip().addView((View)view);
        }
        if (this.adapter != null && this.adapter.getItemCount() > 0 && (curItem = this.viewPager.getCurrentItem()) != this.tabLayout.getSlidingTabStrip().getSelectedPosition()) {
            this.tabLayout.getSlidingTabStrip().setTabSelected(true);
            this.tabLayout.getSlidingTabStrip().setSelectedPosition(curItem);
        }
        if (this.tabLayout.getOnTabCreatedListener() != null) {
            this.tabLayout.getOnTabCreatedListener().onCreated();
        }
    }

    private class TabClickListener
    implements View.OnClickListener {
        private final SlidingTabLayout mTabLayout;

        TabClickListener(SlidingTabLayout tabLayout) {
            this.mTabLayout = tabLayout;
        }

        public void onClick(View view) {
            for (int i = 0; i < this.mTabLayout.getSlidingTabStrip().getChildCount(); ++i) {
                if (view != this.mTabLayout.getSlidingTabStrip().getChildAt(i)) continue;
                this.mTabLayout.getSlidingTabStrip().setTabSelected(true);
                if (this.mTabLayout.getOnTabClickListener() != null) {
                    this.mTabLayout.getOnTabClickListener().onClick(i);
                }
                if (SlidingTabLayoutMediator.this.viewPager.getCurrentItem() == i && this.mTabLayout.getOnSelectedTabClickListener() != null) {
                    this.mTabLayout.getOnSelectedTabClickListener().onClick(i);
                }
                SlidingTabLayoutMediator.this.viewPager.setCurrentItem(i, SlidingTabLayoutMediator.this.tabLayout.getSmoothScroll());
                break;
            }
        }
    }

    public static abstract class SlidingTabPageAdapter
    extends FragmentStateAdapter {
        public SlidingTabPageAdapter(@NonNull FragmentActivity fragmentActivity) {
            this(fragmentActivity.getSupportFragmentManager(), fragmentActivity.getLifecycle());
        }

        public SlidingTabPageAdapter(@NonNull Fragment fragment) {
            this(fragment.getChildFragmentManager(), fragment.getLifecycle());
        }

        public SlidingTabPageAdapter(@NonNull FragmentManager fragmentManager, @NonNull Lifecycle lifecycle) {
            super(fragmentManager, lifecycle);
        }

        @Nullable
        public Drawable getDrawable(int position) {
            return null;
        }

        public abstract CharSequence getPageTitle(int var1);
    }

    private class PagerAdapterObserver
    extends RecyclerView.AdapterDataObserver {
        PagerAdapterObserver() {
        }

        public void onChanged() {
            SlidingTabLayoutMediator.this.populateTabsFromPagerAdapter();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            SlidingTabLayoutMediator.this.populateTabsFromPagerAdapter();
        }

        public void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
            SlidingTabLayoutMediator.this.populateTabsFromPagerAdapter();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            SlidingTabLayoutMediator.this.populateTabsFromPagerAdapter();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            SlidingTabLayoutMediator.this.populateTabsFromPagerAdapter();
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            SlidingTabLayoutMediator.this.populateTabsFromPagerAdapter();
        }
    }

    private static class ViewPagerOnTabSelectedListener
    implements SlidingTabLayout.OnTabSelectedListener {
        private final ViewPager2 viewPager;
        private final boolean smoothScroll;

        ViewPagerOnTabSelectedListener(ViewPager2 viewPager, boolean smoothScroll) {
            this.viewPager = viewPager;
            this.smoothScroll = smoothScroll;
        }

        @Override
        public void onSelected(int position) {
            this.viewPager.setCurrentItem(position, this.smoothScroll);
        }
    }

    private static class TabLayoutOnPageChangeCallback
    extends ViewPager2.OnPageChangeCallback {
        @NonNull
        private final WeakReference<SlidingTabLayout> tabLayoutRef;

        TabLayoutOnPageChangeCallback(SlidingTabLayout tabLayout) {
            this.tabLayoutRef = new WeakReference<SlidingTabLayout>(tabLayout);
        }

        public void onPageScrollStateChanged(int state) {
            SlidingTabLayout tabLayout = (SlidingTabLayout)((Object)this.tabLayoutRef.get());
            tabLayout.getSlidingTabStrip().setTabSelected(state == 0);
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            SlidingTabLayout tabLayout = (SlidingTabLayout)((Object)this.tabLayoutRef.get());
            if (tabLayout != null) {
                int childCount = tabLayout.getSlidingTabStrip().getChildCount();
                if (position >= 0 && position < childCount) {
                    tabLayout.getSlidingTabStrip().setFirstPagePosition(position, positionOffset);
                    tabLayout.scrollToSelectedTab(position, positionOffset);
                }
            }
        }

        public void onPageSelected(int position) {
            SlidingTabLayout tabLayout = (SlidingTabLayout)((Object)this.tabLayoutRef.get());
            if (tabLayout != null) {
                tabLayout.getSlidingTabStrip().setTabSelected(true);
                tabLayout.getSlidingTabStrip().setSelectedPosition(position);
                if (tabLayout.getOnTabSelectedListener() != null) {
                    tabLayout.getOnTabSelectedListener().onSelected(position);
                }
            }
        }
    }
}

