/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.attributes;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.attributes.AttributeRepositoryClass;
import org.apache.commons.attributes.Util;

public class RuntimeAttributeRepository
implements AttributeRepositoryClass {
    private boolean sealed = false;
    private final Set classAttributes = new HashSet();
    private final Map fieldAttributes = new HashMap();
    private final Map constructorAttributes = new HashMap();
    private final Map methodAttributes = new HashMap();
    private final Class clazz;

    public RuntimeAttributeRepository(Class clazz) {
        this.clazz = clazz;
    }

    public void addClassAttribute(Object attribute) {
        this.classAttributes.add(attribute);
    }

    private void checkSealed() throws IllegalStateException {
        if (this.sealed) {
            throw new IllegalStateException("RuntimeAttributeRepository has been sealed.");
        }
    }

    private List getMethodOrConstructorAttributeBundle(Map map, String signature, int numSlots) {
        ArrayList bundle = (ArrayList)map.get(signature);
        if (bundle == null) {
            bundle = new ArrayList();
            map.put(signature, bundle);
            int i = 0;
            while (i < numSlots) {
                bundle.add(new HashSet());
                ++i;
            }
        }
        return bundle;
    }

    private List getMethodAttributeBundle(Method m) {
        String signature = Util.getSignature(m);
        if (m.getDeclaringClass() != this.clazz) {
            throw new IllegalArgumentException("There is no " + signature + " in " + this.clazz.getName() + ". It is defined in " + m.getDeclaringClass().getName());
        }
        return this.getMethodOrConstructorAttributeBundle(this.methodAttributes, signature, m.getParameterTypes().length + 2);
    }

    private List getConstructorAttributeBundle(Constructor c) {
        String signature = Util.getSignature(c);
        if (c.getDeclaringClass() != this.clazz) {
            throw new IllegalArgumentException("There is no " + signature + " in " + this.clazz.getName() + ". It is defined in " + c.getDeclaringClass().getName());
        }
        return this.getMethodOrConstructorAttributeBundle(this.constructorAttributes, signature, c.getParameterTypes().length + 1);
    }

    public void addFieldAttribute(String name, Object attribute) throws NoSuchFieldException, SecurityException {
        this.addFieldAttribute(this.clazz.getDeclaredField(name), attribute);
    }

    public void addFieldAttribute(Field f, Object attribute) {
        this.checkSealed();
        String signature = f.getName();
        if (f.getDeclaringClass() != this.clazz) {
            throw new IllegalArgumentException("There is no " + signature + " in " + this.clazz.getName() + ". It is defined in " + f.getDeclaringClass().getName());
        }
        HashSet<Object> attributeSet = (HashSet<Object>)this.fieldAttributes.get(signature);
        if (attributeSet == null) {
            attributeSet = new HashSet<Object>();
            this.fieldAttributes.put(signature, attributeSet);
        }
        attributeSet.add(attribute);
    }

    public void addConstructorAttribute(Class[] parameters, Object attribute) throws NoSuchMethodException, SecurityException {
        this.addConstructorAttribute(this.clazz.getDeclaredConstructor(parameters), attribute);
    }

    public void addConstructorAttribute(Constructor c, Object attribute) {
        this.checkSealed();
        List bundle = this.getConstructorAttributeBundle(c);
        Set ctorAttrs = (Set)bundle.get(0);
        ctorAttrs.add(attribute);
    }

    public void addMethodAttribute(String name, Class[] parameters, Object attribute) throws NoSuchMethodException, SecurityException {
        this.addMethodAttribute(this.clazz.getDeclaredMethod(name, parameters), attribute);
    }

    public void addMethodAttribute(Method m, Object attribute) {
        this.checkSealed();
        List bundle = this.getMethodAttributeBundle(m);
        Set methodAttrs = (Set)bundle.get(0);
        methodAttrs.add(attribute);
    }

    public void addParameterAttribute(Class[] parameters, int parameterIndex, Object attribute) throws NoSuchMethodException, SecurityException {
        this.addParameterAttribute(this.clazz.getDeclaredConstructor(parameters), parameterIndex, attribute);
    }

    public void addParameterAttribute(Constructor c, int parameterIndex, Object attribute) {
        this.checkSealed();
        List bundle = this.getConstructorAttributeBundle(c);
        Set parameterAttrs = (Set)bundle.get(parameterIndex + 1);
        parameterAttrs.add(attribute);
    }

    public void addParameterAttribute(String name, Class[] parameters, int parameterIndex, Object attribute) throws NoSuchMethodException, SecurityException {
        this.addParameterAttribute(this.clazz.getDeclaredMethod(name, parameters), parameterIndex, attribute);
    }

    public void addParameterAttribute(Method m, int parameterIndex, Object attribute) {
        this.checkSealed();
        List bundle = this.getMethodAttributeBundle(m);
        Set parameterAttrs = (Set)bundle.get(parameterIndex + 2);
        parameterAttrs.add(attribute);
    }

    public void addReturnAttribute(String name, Class[] parameters, Object attribute) throws NoSuchMethodException, SecurityException {
        this.addReturnAttribute(this.clazz.getDeclaredMethod(name, parameters), attribute);
    }

    public void addReturnAttribute(Method m, Object attribute) {
        this.checkSealed();
        List bundle = this.getMethodAttributeBundle(m);
        Set returnAttrs = (Set)bundle.get(1);
        returnAttrs.add(attribute);
    }

    public Class getDefinedClass() {
        return this.clazz;
    }

    public Set getClassAttributes() {
        return this.classAttributes;
    }

    public Map getFieldAttributes() {
        return this.fieldAttributes;
    }

    public Map getMethodAttributes() {
        return this.methodAttributes;
    }

    public Map getConstructorAttributes() {
        return this.constructorAttributes;
    }

    public void seal() {
        this.sealed = true;
    }
}

