/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import junit.framework.Assert;
import org.apache.commons.collections.BulkTest;
import org.apache.commons.collections.map.AbstractTestMap;

public abstract class AbstractTestSortedMap
extends AbstractTestMap {
    public AbstractTestSortedMap(String testName) {
        super(testName);
    }

    public boolean isAllowNullKey() {
        return false;
    }

    public Map makeConfirmedMap() {
        return new TreeMap();
    }

    public void testComparator() {
        SortedMap sortedMap = (SortedMap)this.makeFullMap();
    }

    public void testFirstKey() {
        SortedMap sm = (SortedMap)this.makeFullMap();
        Assert.assertSame(sm.keySet().iterator().next(), sm.firstKey());
    }

    public void testLastKey() {
        SortedMap sm = (SortedMap)this.makeFullMap();
        Object obj = null;
        Iterator it = sm.keySet().iterator();
        while (it.hasNext()) {
            obj = it.next();
        }
        Assert.assertSame(obj, sm.lastKey());
    }

    public BulkTest bulkTestHeadMap() {
        return new TestHeadMap(this);
    }

    public BulkTest bulkTestTailMap() {
        return new TestTailMap(this);
    }

    public BulkTest bulkTestSubMap() {
        return new TestSubMap(this);
    }

    public static class TestSubMap
    extends TestViewMap {
        static final int SUBSIZE = 3;
        final Object fromKey;
        final Object toKey;

        public TestSubMap(AbstractTestMap main) {
            super("SortedMap.SubMap", main);
            SortedMap sm = (SortedMap)main.makeFullMap();
            Iterator it = sm.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.subSortedKeys.add(entry.getKey());
                this.subSortedValues.add(entry.getValue());
            }
            this.fromKey = this.subSortedKeys.get(3);
            this.toKey = this.subSortedKeys.get(this.subSortedKeys.size() - 3);
            this.subSortedKeys.subList(0, 3).clear();
            this.subSortedKeys.subList(this.subSortedKeys.size() - 3, this.subSortedKeys.size()).clear();
            this.subSortedValues.subList(0, 3).clear();
            this.subSortedValues.subList(this.subSortedValues.size() - 3, this.subSortedValues.size()).clear();
            this.subSortedNewValues.addAll(Arrays.asList(main.getNewSampleValues()).subList(3, this.main.getNewSampleValues().length - 3));
        }

        public Map makeEmptyMap() {
            return ((SortedMap)this.main.makeEmptyMap()).subMap(this.fromKey, this.toKey);
        }

        public Map makeFullMap() {
            return ((SortedMap)this.main.makeFullMap()).subMap(this.fromKey, this.toKey);
        }

        public void testSubMapOutOfRange() {
            if (!this.isPutAddSupported()) {
                return;
            }
            this.resetEmpty();
            try {
                ((SortedMap)this.map).put(this.toKey, this.subSortedValues.get(0));
                Assert.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.verify();
        }
    }

    public static class TestTailMap
    extends TestViewMap {
        static final int SUBSIZE = 6;
        final Object fromKey;
        final Object invalidKey;

        public TestTailMap(AbstractTestMap main) {
            super("SortedMap.TailMap", main);
            SortedMap sm = (SortedMap)main.makeFullMap();
            Iterator it = sm.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.subSortedKeys.add(entry.getKey());
                this.subSortedValues.add(entry.getValue());
            }
            this.fromKey = this.subSortedKeys.get(this.subSortedKeys.size() - 6);
            this.invalidKey = this.subSortedKeys.get(this.subSortedKeys.size() - 6 - 1);
            this.subSortedKeys.subList(0, this.subSortedKeys.size() - 6).clear();
            this.subSortedValues.subList(0, this.subSortedValues.size() - 6).clear();
            this.subSortedNewValues.addAll(Arrays.asList(main.getNewSampleValues()).subList(0, 6));
        }

        public Map makeEmptyMap() {
            return ((SortedMap)this.main.makeEmptyMap()).tailMap(this.fromKey);
        }

        public Map makeFullMap() {
            return ((SortedMap)this.main.makeFullMap()).tailMap(this.fromKey);
        }

        public void testTailMapOutOfRange() {
            if (!this.isPutAddSupported()) {
                return;
            }
            this.resetEmpty();
            try {
                ((SortedMap)this.map).put(this.invalidKey, this.subSortedValues.get(0));
                Assert.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.verify();
        }
    }

    public static class TestHeadMap
    extends TestViewMap {
        static final int SUBSIZE = 6;
        final Object toKey;

        public TestHeadMap(AbstractTestMap main) {
            super("SortedMap.HeadMap", main);
            SortedMap sm = (SortedMap)main.makeFullMap();
            Iterator it = sm.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.subSortedKeys.add(entry.getKey());
                this.subSortedValues.add(entry.getValue());
            }
            this.toKey = this.subSortedKeys.get(6);
            this.subSortedKeys.subList(6, this.subSortedKeys.size()).clear();
            this.subSortedValues.subList(6, this.subSortedValues.size()).clear();
            this.subSortedNewValues.addAll(Arrays.asList(main.getNewSampleValues()).subList(0, 6));
        }

        public Map makeEmptyMap() {
            return ((SortedMap)this.main.makeEmptyMap()).headMap(this.toKey);
        }

        public Map makeFullMap() {
            return ((SortedMap)this.main.makeFullMap()).headMap(this.toKey);
        }

        public void testHeadMapOutOfRange() {
            if (!this.isPutAddSupported()) {
                return;
            }
            this.resetEmpty();
            try {
                ((SortedMap)this.map).put(this.toKey, this.subSortedValues.get(0));
                Assert.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.verify();
        }
    }

    public static abstract class TestViewMap
    extends AbstractTestSortedMap {
        protected final AbstractTestMap main;
        protected final List subSortedKeys = new ArrayList();
        protected final List subSortedValues = new ArrayList();
        protected final List subSortedNewValues = new ArrayList();

        public TestViewMap(String name, AbstractTestMap main) {
            super(name);
            this.main = main;
        }

        public void resetEmpty() {
            this.main.resetEmpty();
            super.resetEmpty();
        }

        public void resetFull() {
            this.main.resetFull();
            super.resetFull();
        }

        public void verify() {
            super.verify();
            this.main.verify();
        }

        public BulkTest bulkTestHeadMap() {
            return null;
        }

        public BulkTest bulkTestTailMap() {
            return null;
        }

        public BulkTest bulkTestSubMap() {
            return null;
        }

        public Object[] getSampleKeys() {
            return this.subSortedKeys.toArray();
        }

        public Object[] getSampleValues() {
            return this.subSortedValues.toArray();
        }

        public Object[] getNewSampleValues() {
            return this.subSortedNewValues.toArray();
        }

        public String getCompatibilityVersion() {
            return this.main.getCompatibilityVersion();
        }

        public boolean isAllowNullKey() {
            return this.main.isAllowNullKey();
        }

        public boolean isAllowNullValue() {
            return this.main.isAllowNullValue();
        }

        public boolean isPutAddSupported() {
            return this.main.isPutAddSupported();
        }

        public boolean isPutChangeSupported() {
            return this.main.isPutChangeSupported();
        }

        public boolean isRemoveSupported() {
            return this.main.isRemoveSupported();
        }

        public boolean supportsEmptyCollections() {
            return false;
        }

        public boolean supportsFullCollections() {
            return false;
        }
    }
}

