/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.bidimap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import junit.framework.Assert;
import org.apache.commons.collections.BulkTest;
import org.apache.commons.collections.SortedBidiMap;
import org.apache.commons.collections.bidimap.AbstractTestOrderedBidiMap;
import org.apache.commons.collections.map.AbstractTestSortedMap;

public abstract class AbstractTestSortedBidiMap
extends AbstractTestOrderedBidiMap {
    protected List sortedKeys = new ArrayList();
    protected List sortedValues = new ArrayList();
    protected SortedSet sortedNewValues = new TreeSet();

    public AbstractTestSortedBidiMap(String testName) {
        super(testName);
        this.sortedKeys.addAll(Arrays.asList(this.getSampleKeys()));
        Collections.sort(this.sortedKeys);
        this.sortedKeys = Collections.unmodifiableList(this.sortedKeys);
        TreeMap<Object, Object> map = new TreeMap<Object, Object>();
        int i = 0;
        while (i < this.getSampleKeys().length) {
            map.put(this.getSampleKeys()[i], this.getSampleValues()[i]);
            ++i;
        }
        this.sortedValues.addAll(map.values());
        this.sortedValues = Collections.unmodifiableList(this.sortedValues);
        this.sortedNewValues.addAll(Arrays.asList(this.getNewSampleValues()));
    }

    public AbstractTestSortedBidiMap() {
        this.sortedKeys.addAll(Arrays.asList(this.getSampleValues()));
        Collections.sort(this.sortedKeys);
        this.sortedKeys = Collections.unmodifiableList(this.sortedKeys);
        TreeMap<Object, Object> map = new TreeMap<Object, Object>();
        int i = 0;
        while (i < this.getSampleKeys().length) {
            map.put(this.getSampleValues()[i], this.getSampleKeys()[i]);
            ++i;
        }
        this.sortedValues.addAll(map.values());
        this.sortedValues = Collections.unmodifiableList(this.sortedValues);
        this.sortedNewValues.addAll(Arrays.asList(this.getNewSampleValues()));
    }

    public boolean isAllowNullKey() {
        return false;
    }

    public boolean isAllowNullValue() {
        return false;
    }

    public Map makeConfirmedMap() {
        return new TreeMap();
    }

    public void testBidiHeadMapContains() {
        SortedBidiMap sm = (SortedBidiMap)this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        Object first = it.next();
        Object toKey = it.next();
        Object second = it.next();
        Object firstValue = sm.get(first);
        Object secondValue = sm.get(second);
        SortedMap head = sm.headMap(toKey);
        Assert.assertEquals((int)1, (int)head.size());
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(first));
        Assert.assertEquals((boolean)true, (boolean)head.containsKey(first));
        Assert.assertEquals((boolean)true, (boolean)sm.containsValue(firstValue));
        Assert.assertEquals((boolean)true, (boolean)head.containsValue(firstValue));
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(second));
        Assert.assertEquals((boolean)false, (boolean)head.containsKey(second));
        Assert.assertEquals((boolean)true, (boolean)sm.containsValue(secondValue));
        Assert.assertEquals((boolean)false, (boolean)head.containsValue(secondValue));
    }

    public void testBidiClearByHeadMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap sm = (SortedBidiMap)this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        Object first = it.next();
        Object second = it.next();
        Object toKey = it.next();
        Object firstValue = sm.get(first);
        Object secondValue = sm.get(second);
        Object toKeyValue = sm.get(toKey);
        SortedMap sub = sm.headMap(toKey);
        int size = sm.size();
        Assert.assertEquals((int)2, (int)sub.size());
        sub.clear();
        Assert.assertEquals((int)0, (int)sub.size());
        Assert.assertEquals((int)(size - 2), (int)sm.size());
        Assert.assertEquals((int)(size - 2), (int)sm.inverseBidiMap().size());
        Assert.assertEquals((boolean)false, (boolean)sm.containsKey(first));
        Assert.assertEquals((boolean)false, (boolean)sm.containsValue(firstValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(firstValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(first));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(first));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(firstValue));
        Assert.assertEquals((boolean)false, (boolean)sm.containsKey(second));
        Assert.assertEquals((boolean)false, (boolean)sm.containsValue(secondValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(secondValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(second));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(second));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(secondValue));
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(toKey));
        Assert.assertEquals((boolean)true, (boolean)sm.containsValue(toKeyValue));
        Assert.assertEquals((boolean)true, (boolean)sm.inverseBidiMap().containsKey(toKeyValue));
        Assert.assertEquals((boolean)true, (boolean)sm.inverseBidiMap().containsValue(toKey));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(toKey));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(toKeyValue));
    }

    public void testBidiRemoveByHeadMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap sm = (SortedBidiMap)this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        Object first = it.next();
        Object second = it.next();
        Object toKey = it.next();
        int size = sm.size();
        SortedMap sub = sm.headMap(toKey);
        Assert.assertEquals((int)2, (int)sub.size());
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(first));
        Assert.assertEquals((boolean)true, (boolean)sub.containsKey(first));
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(second));
        Assert.assertEquals((boolean)true, (boolean)sub.containsKey(second));
        Object firstValue = sub.remove(first);
        Assert.assertEquals((int)1, (int)sub.size());
        Assert.assertEquals((int)(size - 1), (int)sm.size());
        Assert.assertEquals((int)(size - 1), (int)sm.inverseBidiMap().size());
        Assert.assertEquals((boolean)false, (boolean)sm.containsKey(first));
        Assert.assertEquals((boolean)false, (boolean)sm.containsValue(firstValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(firstValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(first));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(first));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(firstValue));
        Object secondValue = sub.remove(second);
        Assert.assertEquals((int)0, (int)sub.size());
        Assert.assertEquals((int)(size - 2), (int)sm.size());
        Assert.assertEquals((int)(size - 2), (int)sm.inverseBidiMap().size());
        Assert.assertEquals((boolean)false, (boolean)sm.containsKey(second));
        Assert.assertEquals((boolean)false, (boolean)sm.containsValue(secondValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(secondValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(second));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(second));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(secondValue));
    }

    public void testBidiRemoveByHeadMapEntrySet() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap sm = (SortedBidiMap)this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        Object first = it.next();
        Object second = it.next();
        Object toKey = it.next();
        int size = sm.size();
        SortedMap sub = sm.headMap(toKey);
        Set set = sub.entrySet();
        Assert.assertEquals((int)2, (int)sub.size());
        Assert.assertEquals((int)2, (int)set.size());
        Iterator it2 = set.iterator();
        Map.Entry firstEntry = this.cloneMapEntry(it2.next());
        Map.Entry secondEntry = this.cloneMapEntry(it2.next());
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(first));
        Assert.assertEquals((boolean)true, (boolean)sub.containsKey(first));
        Assert.assertEquals((boolean)true, (boolean)set.contains(firstEntry));
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(second));
        Assert.assertEquals((boolean)true, (boolean)sub.containsKey(second));
        Assert.assertEquals((boolean)true, (boolean)set.contains(secondEntry));
        set.remove(firstEntry);
        Assert.assertEquals((int)1, (int)sub.size());
        Assert.assertEquals((int)(size - 1), (int)sm.size());
        Assert.assertEquals((int)(size - 1), (int)sm.inverseBidiMap().size());
        Assert.assertEquals((boolean)false, (boolean)sm.containsKey(firstEntry.getKey()));
        Assert.assertEquals((boolean)false, (boolean)sm.containsValue(firstEntry.getValue()));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(firstEntry.getValue()));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(firstEntry.getKey()));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(firstEntry.getKey()));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(firstEntry.getValue()));
        Assert.assertEquals((boolean)false, (boolean)set.contains(firstEntry));
        set.remove(secondEntry);
        Assert.assertEquals((int)0, (int)sub.size());
        Assert.assertEquals((int)(size - 2), (int)sm.size());
        Assert.assertEquals((int)(size - 2), (int)sm.inverseBidiMap().size());
        Assert.assertEquals((boolean)false, (boolean)sm.containsKey(secondEntry.getKey()));
        Assert.assertEquals((boolean)false, (boolean)sm.containsValue(secondEntry.getValue()));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(secondEntry.getValue()));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(secondEntry.getKey()));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(secondEntry.getKey()));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(secondEntry.getValue()));
        Assert.assertEquals((boolean)false, (boolean)set.contains(secondEntry));
    }

    public void testBidiTailMapContains() {
        SortedBidiMap sm = (SortedBidiMap)this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        Object first = it.next();
        Object fromKey = it.next();
        Object second = it.next();
        Object firstValue = sm.get(first);
        Object fromKeyValue = sm.get(fromKey);
        Object secondValue = sm.get(second);
        SortedMap sub = sm.tailMap(fromKey);
        Assert.assertEquals((int)(sm.size() - 1), (int)sub.size());
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(first));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(first));
        Assert.assertEquals((boolean)true, (boolean)sm.containsValue(firstValue));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(firstValue));
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(fromKey));
        Assert.assertEquals((boolean)true, (boolean)sub.containsKey(fromKey));
        Assert.assertEquals((boolean)true, (boolean)sm.containsValue(fromKeyValue));
        Assert.assertEquals((boolean)true, (boolean)sub.containsValue(fromKeyValue));
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(second));
        Assert.assertEquals((boolean)true, (boolean)sub.containsKey(second));
        Assert.assertEquals((boolean)true, (boolean)sm.containsValue(secondValue));
        Assert.assertEquals((boolean)true, (boolean)sub.containsValue(secondValue));
    }

    public void testBidiClearByTailMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap sm = (SortedBidiMap)this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        it.next();
        it.next();
        Object first = it.next();
        Object fromKey = it.next();
        Object second = it.next();
        Object firstValue = sm.get(first);
        Object fromKeyValue = sm.get(fromKey);
        Object secondValue = sm.get(second);
        SortedMap sub = sm.tailMap(fromKey);
        int size = sm.size();
        Assert.assertEquals((int)(size - 3), (int)sub.size());
        sub.clear();
        Assert.assertEquals((int)0, (int)sub.size());
        Assert.assertEquals((int)3, (int)sm.size());
        Assert.assertEquals((int)3, (int)sm.inverseBidiMap().size());
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(first));
        Assert.assertEquals((boolean)true, (boolean)sm.containsValue(firstValue));
        Assert.assertEquals((boolean)true, (boolean)sm.inverseBidiMap().containsKey(firstValue));
        Assert.assertEquals((boolean)true, (boolean)sm.inverseBidiMap().containsValue(first));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(first));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(firstValue));
        Assert.assertEquals((boolean)false, (boolean)sm.containsKey(fromKey));
        Assert.assertEquals((boolean)false, (boolean)sm.containsValue(fromKeyValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(fromKeyValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(fromKey));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(fromKey));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(fromKeyValue));
        Assert.assertEquals((boolean)false, (boolean)sm.containsKey(second));
        Assert.assertEquals((boolean)false, (boolean)sm.containsValue(secondValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(secondValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(second));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(second));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(secondValue));
    }

    public void testBidiRemoveByTailMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap sm = (SortedBidiMap)this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        it.next();
        it.next();
        Object fromKey = it.next();
        Object first = it.next();
        Object second = it.next();
        int size = sm.size();
        SortedMap sub = sm.tailMap(fromKey);
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(first));
        Assert.assertEquals((boolean)true, (boolean)sub.containsKey(first));
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(second));
        Assert.assertEquals((boolean)true, (boolean)sub.containsKey(second));
        Object firstValue = sub.remove(first);
        Assert.assertEquals((int)(size - 3), (int)sub.size());
        Assert.assertEquals((int)(size - 1), (int)sm.size());
        Assert.assertEquals((int)(size - 1), (int)sm.inverseBidiMap().size());
        Assert.assertEquals((boolean)false, (boolean)sm.containsKey(first));
        Assert.assertEquals((boolean)false, (boolean)sm.containsValue(firstValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(firstValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(first));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(first));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(firstValue));
        Object secondValue = sub.remove(second);
        Assert.assertEquals((int)(size - 4), (int)sub.size());
        Assert.assertEquals((int)(size - 2), (int)sm.size());
        Assert.assertEquals((int)(size - 2), (int)sm.inverseBidiMap().size());
        Assert.assertEquals((boolean)false, (boolean)sm.containsKey(second));
        Assert.assertEquals((boolean)false, (boolean)sm.containsValue(secondValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(secondValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(second));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(second));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(secondValue));
    }

    public void testBidiRemoveByTailMapEntrySet() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap sm = (SortedBidiMap)this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        it.next();
        it.next();
        Object fromKey = it.next();
        Object first = it.next();
        Object second = it.next();
        int size = sm.size();
        SortedMap sub = sm.tailMap(fromKey);
        Set set = sub.entrySet();
        Iterator it2 = set.iterator();
        Map.Entry fromEntry = it2.next();
        Map.Entry firstEntry = this.cloneMapEntry(it2.next());
        Map.Entry secondEntry = this.cloneMapEntry(it2.next());
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(first));
        Assert.assertEquals((boolean)true, (boolean)sub.containsKey(first));
        Assert.assertEquals((boolean)true, (boolean)set.contains(firstEntry));
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(second));
        Assert.assertEquals((boolean)true, (boolean)sub.containsKey(second));
        Assert.assertEquals((boolean)true, (boolean)set.contains(secondEntry));
        set.remove(firstEntry);
        Assert.assertEquals((int)(size - 3), (int)sub.size());
        Assert.assertEquals((int)(size - 1), (int)sm.size());
        Assert.assertEquals((int)(size - 1), (int)sm.inverseBidiMap().size());
        Assert.assertEquals((boolean)false, (boolean)sm.containsKey(firstEntry.getKey()));
        Assert.assertEquals((boolean)false, (boolean)sm.containsValue(firstEntry.getValue()));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(firstEntry.getValue()));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(firstEntry.getKey()));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(firstEntry.getKey()));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(firstEntry.getValue()));
        Assert.assertEquals((boolean)false, (boolean)set.contains(firstEntry));
        set.remove(secondEntry);
        Assert.assertEquals((int)(size - 4), (int)sub.size());
        Assert.assertEquals((int)(size - 2), (int)sm.size());
        Assert.assertEquals((int)(size - 2), (int)sm.inverseBidiMap().size());
        Assert.assertEquals((boolean)false, (boolean)sm.containsKey(secondEntry.getKey()));
        Assert.assertEquals((boolean)false, (boolean)sm.containsValue(secondEntry.getValue()));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(secondEntry.getValue()));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(secondEntry.getKey()));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(secondEntry.getKey()));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(secondEntry.getValue()));
        Assert.assertEquals((boolean)false, (boolean)set.contains(secondEntry));
    }

    public void testBidiSubMapContains() {
        SortedBidiMap sm = (SortedBidiMap)this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        Object first = it.next();
        Object fromKey = it.next();
        Object second = it.next();
        Object toKey = it.next();
        Object third = it.next();
        Object firstValue = sm.get(first);
        Object fromKeyValue = sm.get(fromKey);
        Object secondValue = sm.get(second);
        Object thirdValue = sm.get(third);
        SortedMap sub = sm.subMap(fromKey, toKey);
        Assert.assertEquals((int)2, (int)sub.size());
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(first));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(first));
        Assert.assertEquals((boolean)true, (boolean)sm.containsValue(firstValue));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(firstValue));
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(fromKey));
        Assert.assertEquals((boolean)true, (boolean)sub.containsKey(fromKey));
        Assert.assertEquals((boolean)true, (boolean)sm.containsValue(fromKeyValue));
        Assert.assertEquals((boolean)true, (boolean)sub.containsValue(fromKeyValue));
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(second));
        Assert.assertEquals((boolean)true, (boolean)sub.containsKey(second));
        Assert.assertEquals((boolean)true, (boolean)sm.containsValue(secondValue));
        Assert.assertEquals((boolean)true, (boolean)sub.containsValue(secondValue));
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(third));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(third));
        Assert.assertEquals((boolean)true, (boolean)sm.containsValue(thirdValue));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(thirdValue));
    }

    public void testBidiClearBySubMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap sm = (SortedBidiMap)this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        it.next();
        Object fromKey = it.next();
        Object first = it.next();
        Object second = it.next();
        Object toKey = it.next();
        Object fromKeyValue = sm.get(fromKey);
        Object firstValue = sm.get(first);
        Object secondValue = sm.get(second);
        Object toKeyValue = sm.get(toKey);
        SortedMap sub = sm.subMap(fromKey, toKey);
        int size = sm.size();
        Assert.assertEquals((int)3, (int)sub.size());
        sub.clear();
        Assert.assertEquals((int)0, (int)sub.size());
        Assert.assertEquals((int)(size - 3), (int)sm.size());
        Assert.assertEquals((int)(size - 3), (int)sm.inverseBidiMap().size());
        Assert.assertEquals((boolean)false, (boolean)sm.containsKey(fromKey));
        Assert.assertEquals((boolean)false, (boolean)sm.containsValue(fromKeyValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(fromKeyValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(fromKey));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(fromKey));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(fromKeyValue));
        Assert.assertEquals((boolean)false, (boolean)sm.containsKey(first));
        Assert.assertEquals((boolean)false, (boolean)sm.containsValue(firstValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(firstValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(first));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(first));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(firstValue));
        Assert.assertEquals((boolean)false, (boolean)sm.containsKey(second));
        Assert.assertEquals((boolean)false, (boolean)sm.containsValue(secondValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(secondValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(second));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(second));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(secondValue));
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(toKey));
        Assert.assertEquals((boolean)true, (boolean)sm.containsValue(toKeyValue));
        Assert.assertEquals((boolean)true, (boolean)sm.inverseBidiMap().containsKey(toKeyValue));
        Assert.assertEquals((boolean)true, (boolean)sm.inverseBidiMap().containsValue(toKey));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(toKey));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(toKeyValue));
    }

    public void testBidiRemoveBySubMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap sm = (SortedBidiMap)this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        it.next();
        it.next();
        Object fromKey = it.next();
        Object first = it.next();
        Object second = it.next();
        Object toKey = it.next();
        int size = sm.size();
        SortedMap sub = sm.subMap(fromKey, toKey);
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(first));
        Assert.assertEquals((boolean)true, (boolean)sub.containsKey(first));
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(second));
        Assert.assertEquals((boolean)true, (boolean)sub.containsKey(second));
        Object firstValue = sub.remove(first);
        Assert.assertEquals((int)2, (int)sub.size());
        Assert.assertEquals((int)(size - 1), (int)sm.size());
        Assert.assertEquals((int)(size - 1), (int)sm.inverseBidiMap().size());
        Assert.assertEquals((boolean)false, (boolean)sm.containsKey(first));
        Assert.assertEquals((boolean)false, (boolean)sm.containsValue(firstValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(firstValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(first));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(first));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(firstValue));
        Object secondValue = sub.remove(second);
        Assert.assertEquals((int)1, (int)sub.size());
        Assert.assertEquals((int)(size - 2), (int)sm.size());
        Assert.assertEquals((int)(size - 2), (int)sm.inverseBidiMap().size());
        Assert.assertEquals((boolean)false, (boolean)sm.containsKey(second));
        Assert.assertEquals((boolean)false, (boolean)sm.containsValue(secondValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(secondValue));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(second));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(second));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(secondValue));
    }

    public void testBidiRemoveBySubMapEntrySet() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap sm = (SortedBidiMap)this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        it.next();
        it.next();
        Object fromKey = it.next();
        Object first = it.next();
        Object second = it.next();
        Object toKey = it.next();
        int size = sm.size();
        SortedMap sub = sm.subMap(fromKey, toKey);
        Set set = sub.entrySet();
        Assert.assertEquals((int)3, (int)set.size());
        Iterator it2 = set.iterator();
        Map.Entry fromEntry = it2.next();
        Map.Entry firstEntry = this.cloneMapEntry(it2.next());
        Map.Entry secondEntry = this.cloneMapEntry(it2.next());
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(first));
        Assert.assertEquals((boolean)true, (boolean)sub.containsKey(first));
        Assert.assertEquals((boolean)true, (boolean)set.contains(firstEntry));
        Assert.assertEquals((boolean)true, (boolean)sm.containsKey(second));
        Assert.assertEquals((boolean)true, (boolean)sub.containsKey(second));
        Assert.assertEquals((boolean)true, (boolean)set.contains(secondEntry));
        set.remove(firstEntry);
        Assert.assertEquals((int)2, (int)sub.size());
        Assert.assertEquals((int)(size - 1), (int)sm.size());
        Assert.assertEquals((int)(size - 1), (int)sm.inverseBidiMap().size());
        Assert.assertEquals((boolean)false, (boolean)sm.containsKey(firstEntry.getKey()));
        Assert.assertEquals((boolean)false, (boolean)sm.containsValue(firstEntry.getValue()));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(firstEntry.getValue()));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(firstEntry.getKey()));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(firstEntry.getKey()));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(firstEntry.getValue()));
        Assert.assertEquals((boolean)false, (boolean)set.contains(firstEntry));
        set.remove(secondEntry);
        Assert.assertEquals((int)1, (int)sub.size());
        Assert.assertEquals((int)(size - 2), (int)sm.size());
        Assert.assertEquals((int)(size - 2), (int)sm.inverseBidiMap().size());
        Assert.assertEquals((boolean)false, (boolean)sm.containsKey(secondEntry.getKey()));
        Assert.assertEquals((boolean)false, (boolean)sm.containsValue(secondEntry.getValue()));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsKey(secondEntry.getValue()));
        Assert.assertEquals((boolean)false, (boolean)sm.inverseBidiMap().containsValue(secondEntry.getKey()));
        Assert.assertEquals((boolean)false, (boolean)sub.containsKey(secondEntry.getKey()));
        Assert.assertEquals((boolean)false, (boolean)sub.containsValue(secondEntry.getValue()));
        Assert.assertEquals((boolean)false, (boolean)set.contains(secondEntry));
    }

    public BulkTest bulkTestHeadMap() {
        return new AbstractTestSortedMap.TestHeadMap(this);
    }

    public BulkTest bulkTestTailMap() {
        return new AbstractTestSortedMap.TestTailMap(this);
    }

    public BulkTest bulkTestSubMap() {
        return new AbstractTestSortedMap.TestSubMap(this);
    }
}

