/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.keyvalue;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;

public abstract class AbstractTestMapEntry
extends TestCase {
    protected final String key = "name";
    protected final String value = "duke";

    public AbstractTestMapEntry(String testName) {
        super(testName);
    }

    public Map.Entry makeMapEntry() {
        return this.makeMapEntry(null, null);
    }

    public abstract Map.Entry makeMapEntry(Object var1, Object var2);

    public Map.Entry makeKnownMapEntry() {
        return this.makeKnownMapEntry(null, null);
    }

    public Map.Entry makeKnownMapEntry(Object key, Object value) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(1);
        map.put(key, value);
        Map.Entry entry = map.entrySet().iterator().next();
        return entry;
    }

    public void testAccessorsAndMutators() {
        Map.Entry entry = this.makeMapEntry("name", "duke");
        Assert.assertTrue((entry.getKey() == "name" ? 1 : 0) != 0);
        entry.setValue("duke");
        Assert.assertTrue((entry.getValue() == "duke" ? 1 : 0) != 0);
        entry = this.makeMapEntry(null, null);
        Assert.assertTrue((entry.getKey() == null ? 1 : 0) != 0);
        entry.setValue(null);
        Assert.assertTrue((entry.getValue() == null ? 1 : 0) != 0);
    }

    public void testSelfReferenceHandling() {
        Map.Entry entry = this.makeMapEntry();
        try {
            entry.setValue(entry);
            Assert.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((entry.getKey() == null && entry.getValue() == null ? 1 : 0) != 0);
        }
    }

    public abstract void testConstructors();

    public void testEqualsAndHashCode() {
        Map.Entry e1 = this.makeMapEntry("name", "duke");
        Map.Entry e2 = this.makeKnownMapEntry("name", "duke");
        Assert.assertTrue((boolean)e1.equals(e1));
        Assert.assertTrue((boolean)e2.equals(e1));
        Assert.assertTrue((boolean)e1.equals(e2));
        Assert.assertTrue((e1.hashCode() == e2.hashCode() ? 1 : 0) != 0);
        e1 = this.makeMapEntry();
        e2 = this.makeKnownMapEntry();
        Assert.assertTrue((boolean)e1.equals(e1));
        Assert.assertTrue((boolean)e2.equals(e1));
        Assert.assertTrue((boolean)e1.equals(e2));
        Assert.assertTrue((e1.hashCode() == e2.hashCode() ? 1 : 0) != 0);
    }

    public void testToString() {
        Map.Entry entry = this.makeMapEntry("name", "duke");
        Assert.assertTrue((boolean)entry.toString().equals(entry.getKey() + "=" + entry.getValue()));
        entry = this.makeMapEntry();
        Assert.assertTrue((boolean)entry.toString().equals(entry.getKey() + "=" + entry.getValue()));
    }
}

