/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.set;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import junit.framework.Assert;
import org.apache.commons.collections.BulkTest;
import org.apache.commons.collections.set.AbstractTestSet;

public abstract class AbstractTestSortedSet
extends AbstractTestSet {
    public AbstractTestSortedSet(String name) {
        super(name);
    }

    public void verify() {
        super.verify();
        Iterator colliter = this.collection.iterator();
        Iterator confiter = this.confirmed.iterator();
        Object first = null;
        Object last = null;
        while (colliter.hasNext()) {
            last = first == null ? (first = colliter.next()) : colliter.next();
            Assert.assertEquals((String)"Element appears to be out of order.", last, confiter.next());
        }
        if (this.collection.size() > 0) {
            Assert.assertEquals((String)"Incorrect element returned by first().", first, ((SortedSet)this.collection).first());
            Assert.assertEquals((String)"Incorrect element returned by last().", last, ((SortedSet)this.collection).last());
        }
    }

    public boolean isNullSupported() {
        return false;
    }

    public Collection makeConfirmedCollection() {
        return new TreeSet();
    }

    public SortedSet getConfirmedSortedSet() {
        return (SortedSet)this.confirmed;
    }

    public Object[] getFullNonNullElements() {
        Object[] elements = new Object[30];
        int i = 0;
        while (i < 30) {
            elements[i] = new Integer(i + i + 1);
            ++i;
        }
        return elements;
    }

    public Object[] getOtherNonNullElements() {
        Object[] elements = new Object[30];
        int i = 0;
        while (i < 30) {
            elements[i] = new Integer(i + i + 2);
            ++i;
        }
        return elements;
    }

    public BulkTest bulkTestSortedSetSubSet() {
        int length = this.getFullElements().length;
        int lobound = length / 3;
        int hibound = lobound * 2;
        return new TestSortedSetSubSet(lobound, hibound);
    }

    public BulkTest bulkTestSortedSetHeadSet() {
        int length = this.getFullElements().length;
        int lobound = length / 3;
        int hibound = lobound * 2;
        return new TestSortedSetSubSet(hibound, true);
    }

    public BulkTest bulkTestSortedSetTailSet() {
        int length = this.getFullElements().length;
        int lobound = length / 3;
        return new TestSortedSetSubSet(lobound, false);
    }

    public class TestSortedSetSubSet
    extends AbstractTestSortedSet {
        private int m_Type;
        private int m_LowBound;
        private int m_HighBound;
        private Object[] m_FullElements;
        private Object[] m_OtherElements;
        static final int TYPE_SUBSET = 0;
        static final int TYPE_TAILSET = 1;
        static final int TYPE_HEADSET = 2;

        public TestSortedSetSubSet(int bound, boolean head) {
            super("TestSortedSetSubSet");
            if (head) {
                this.m_Type = 2;
                this.m_HighBound = bound;
                this.m_FullElements = new Object[bound];
                System.arraycopy(AbstractTestSortedSet.this.getFullElements(), 0, this.m_FullElements, 0, bound);
                this.m_OtherElements = new Object[bound - 1];
                System.arraycopy(AbstractTestSortedSet.this.getOtherElements(), 0, this.m_OtherElements, 0, bound - 1);
            } else {
                this.m_Type = 1;
                this.m_LowBound = bound;
                Object[] allelements = AbstractTestSortedSet.this.getFullElements();
                this.m_FullElements = new Object[allelements.length - bound];
                System.arraycopy(allelements, bound, this.m_FullElements, 0, allelements.length - bound);
                this.m_OtherElements = new Object[allelements.length - bound - 1];
                System.arraycopy(AbstractTestSortedSet.this.getOtherElements(), bound, this.m_OtherElements, 0, allelements.length - bound - 1);
            }
        }

        public TestSortedSetSubSet(int lobound, int hibound) {
            super("TestSortedSetSubSet");
            this.m_Type = 0;
            this.m_LowBound = lobound;
            this.m_HighBound = hibound;
            int length = hibound - lobound;
            this.m_FullElements = new Object[length];
            System.arraycopy(AbstractTestSortedSet.this.getFullElements(), lobound, this.m_FullElements, 0, length);
            this.m_OtherElements = new Object[length - 1];
            System.arraycopy(AbstractTestSortedSet.this.getOtherElements(), lobound, this.m_OtherElements, 0, length - 1);
        }

        public boolean isNullSupported() {
            return AbstractTestSortedSet.this.isNullSupported();
        }

        public boolean isAddSupported() {
            return AbstractTestSortedSet.this.isAddSupported();
        }

        public boolean isRemoveSupported() {
            return AbstractTestSortedSet.this.isRemoveSupported();
        }

        public boolean isFailFastSupported() {
            return AbstractTestSortedSet.this.isFailFastSupported();
        }

        public Object[] getFullElements() {
            return this.m_FullElements;
        }

        public Object[] getOtherElements() {
            return this.m_OtherElements;
        }

        private SortedSet getSubSet(SortedSet set) {
            Object[] elements = AbstractTestSortedSet.this.getFullElements();
            switch (this.m_Type) {
                case 0: {
                    return set.subSet(elements[this.m_LowBound], elements[this.m_HighBound]);
                }
                case 2: {
                    return set.headSet(elements[this.m_HighBound]);
                }
                case 1: {
                    return set.tailSet(elements[this.m_LowBound]);
                }
            }
            return null;
        }

        public Set makeEmptySet() {
            SortedSet s = (SortedSet)AbstractTestSortedSet.this.makeEmptySet();
            return this.getSubSet(s);
        }

        public Set makeFullSet() {
            SortedSet s = (SortedSet)AbstractTestSortedSet.this.makeFullCollection();
            return this.getSubSet(s);
        }

        public boolean isTestSerialization() {
            return false;
        }

        public BulkTest bulkTestSortedSetSubSet() {
            return null;
        }

        public BulkTest bulkTestSortedSetHeadSet() {
            return null;
        }

        public BulkTest bulkTestSortedSetTailSet() {
            return null;
        }
    }
}

