/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.naming.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.naming.ContextAccessController;
import org.apache.commons.naming.config.Config;
import org.apache.commons.naming.config.ParseException;
import org.xml.sax.SAXException;

public class XmlConfigurator {
    private static final String COMP_CONTEXT_NAME = "java:comp";
    private static final String ENV_CONTEXT_NAME = "env";
    private static final String ROOT_ELEMENT = "naming";
    private static final String CONTEXT_ELEMENT = "naming/context";
    private static final String ENV_ELEMENT = "naming/context/environment";
    private static final String RES_ELEMENT = "naming/context/resource";
    private static final String RES_PARAM_ELEMENT = "naming/context/resource/parameter";
    private static Context envContext = null;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$naming$config$XmlConfigurator == null ? (class$org$apache$commons$naming$config$XmlConfigurator = XmlConfigurator.class$("org.apache.commons.naming.config.XmlConfigurator")) : class$org$apache$commons$naming$config$XmlConfigurator));
    static /* synthetic */ Class class$org$apache$commons$naming$config$XmlConfigurator;
    static /* synthetic */ Class class$org$apache$commons$naming$config$Config$Naming;
    static /* synthetic */ Class class$org$apache$commons$naming$config$Config$Context;
    static /* synthetic */ Class class$org$apache$commons$naming$config$Config$Environment;
    static /* synthetic */ Class class$org$apache$commons$naming$config$Config$Resource;

    public static synchronized void setupInitialContext() throws NamingException {
        System.setProperty("java.naming.factory.initial", "org.apache.commons.naming.java.javaURLContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "org.apache.commons.naming");
        InitialContext initialContext = new InitialContext();
        envContext = initialContext.createSubcontext(COMP_CONTEXT_NAME).createSubcontext(ENV_CONTEXT_NAME);
    }

    public static synchronized void destroyInitialContext() throws NamingException {
        InitialContext initialContext = new InitialContext();
        Context ctx = (Context)initialContext.lookup(COMP_CONTEXT_NAME);
        ctx.destroySubcontext(ENV_CONTEXT_NAME);
        envContext = null;
        initialContext.destroySubcontext(COMP_CONTEXT_NAME);
        initialContext = null;
    }

    public static synchronized void loadConfiguration(InputStream inputFile) throws NamingException, ParseException {
        if (envContext == null) {
            XmlConfigurator.setupInitialContext();
        }
        ContextAccessController.setWritable((Object)"root", (Object)"x");
        Digester digester = new Digester();
        digester.addObjectCreate(ROOT_ELEMENT, class$org$apache$commons$naming$config$Config$Naming == null ? (class$org$apache$commons$naming$config$Config$Naming = XmlConfigurator.class$("org.apache.commons.naming.config.Config$Naming")) : class$org$apache$commons$naming$config$Config$Naming);
        digester.addObjectCreate(CONTEXT_ELEMENT, class$org$apache$commons$naming$config$Config$Context == null ? (class$org$apache$commons$naming$config$Config$Context = XmlConfigurator.class$("org.apache.commons.naming.config.Config$Context")) : class$org$apache$commons$naming$config$Config$Context);
        digester.addSetProperties(CONTEXT_ELEMENT);
        digester.addSetNext(CONTEXT_ELEMENT, "addContext");
        digester.addObjectCreate(ENV_ELEMENT, class$org$apache$commons$naming$config$Config$Environment == null ? (class$org$apache$commons$naming$config$Config$Environment = XmlConfigurator.class$("org.apache.commons.naming.config.Config$Environment")) : class$org$apache$commons$naming$config$Config$Environment);
        digester.addSetProperties(ENV_ELEMENT);
        digester.addSetNext(ENV_ELEMENT, "addEnvironment");
        digester.addObjectCreate(RES_ELEMENT, class$org$apache$commons$naming$config$Config$Resource == null ? (class$org$apache$commons$naming$config$Config$Resource = XmlConfigurator.class$("org.apache.commons.naming.config.Config$Resource")) : class$org$apache$commons$naming$config$Config$Resource);
        digester.addSetProperties(RES_ELEMENT);
        digester.addSetNext(RES_ELEMENT, "addResource");
        digester.addCallMethod(RES_PARAM_ELEMENT, "addParameter", 2);
        digester.addCallParam("naming/context/resource/parameter/name", 0);
        digester.addCallParam("naming/context/resource/parameter/value", 1);
        try {
            Config.Naming naming = (Config.Naming)digester.parse(inputFile);
            if (naming == null) {
                throw new ParseException("Unable to find root element 'naming'");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("XML configuration loaded: " + naming.toString()));
            }
            XmlConfigurator.precreateSubcontextTree(envContext, naming.generateSortedSubcontextNameSet());
            Iterator i = naming.getContextList().iterator();
            while (i.hasNext()) {
                Config.Context ctx = (Config.Context)i.next();
                Context jndiCtx = envContext;
                if (ctx.getName() != null) {
                    jndiCtx = (Context)jndiCtx.lookup(ctx.getName());
                }
                Iterator j = ctx.getEnvironmentList().iterator();
                while (j.hasNext()) {
                    Config.Environment e = (Config.Environment)j.next();
                    jndiCtx.rebind(e.getName(), e.createValue());
                }
                j = ctx.getResourceList().iterator();
                while (j.hasNext()) {
                    Config.Resource r = (Config.Resource)j.next();
                    jndiCtx.bind(r.getName(), r.createValue());
                }
            }
        }
        catch (IOException e) {
            throw new ParseException("Error reading configuration file", e);
        }
        catch (SAXException e) {
            throw new ParseException("Error reading configuration file", e);
        }
    }

    private static void precreateSubcontextTree(Context ctx, Set sortedSubcontextNameSet) throws NamingException {
        Iterator i = sortedSubcontextNameSet.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            ctx.createSubcontext(name);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

