/*
 * Decompiled with CFR 0.152.
 */
package community.flock.wirespec.plugin.io;

import arrow.core.Either;
import arrow.core.NonEmptySet;
import arrow.core.NonEmptySetKt;
import arrow.core.NonFatalOrThrowKt;
import arrow.core.raise.DefaultRaise;
import arrow.core.raise.Raise;
import arrow.core.raise.RaiseCancellationException;
import arrow.core.raise.RaiseKt;
import community.flock.wirespec.compiler.core.emit.common.FileExtension;
import community.flock.wirespec.plugin.io.CannotAccessFileOrDirectory;
import community.flock.wirespec.plugin.io.ClassPath;
import community.flock.wirespec.plugin.io.DefinitionsKt;
import community.flock.wirespec.plugin.io.Directory;
import community.flock.wirespec.plugin.io.DirectoryPath;
import community.flock.wirespec.plugin.io.FilePath;
import community.flock.wirespec.plugin.io.FullPath;
import community.flock.wirespec.plugin.io.IOError;
import community.flock.wirespec.plugin.io.IsNotAFileOrDirectory;
import community.flock.wirespec.plugin.io.OutputShouldBeADirectory;
import community.flock.wirespec.plugin.io.Source;
import community.flock.wirespec.plugin.io.WirespecFileError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.io.CoreKt;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Sink;
import kotlinx.io.Utf8Kt;
import kotlinx.io.files.FileMetadata;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.FileSystemJvmKt;
import kotlinx.io.files.Path;
import kotlinx.io.files.PathsJvmKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a5\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001*\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u00022\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\b\u001a(\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\f\u001a\u00020\r\u001a$\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u00022\u0006\u0010\u0010\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006\u001a\u0014\u0010\f\u001a\u00020\u0012*\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\r\u001a\n\u0010\u0014\u001a\u00020\u0006*\u00020\u0015\u001a\u0012\u0010\u0016\u001a\u00020\u0017*\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0006\u001a\"\u0010\u0019\u001a\u001a\u0012\u0004\u0012\u00020\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001b0\u0002*\u00020\u001e\u001a\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0012H\u0002\u001a\u0010\u0010!\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0012H\u0002\"\u0018\u0010\"\u001a\u00020\u0006*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"or", "B", "Larrow/core/Either;", "Lcommunity/flock/wirespec/plugin/io/IOError;", "errorFn", "Lkotlin/Function1;", "", "", "(Larrow/core/Either;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getFullPath", "Lcommunity/flock/wirespec/plugin/io/FullPath;", "input", "createIfNotExists", "", "getOutPutPath", "Lcommunity/flock/wirespec/plugin/io/DirectoryPath;", "inputPath", "output", "Lkotlinx/io/files/Path;", "create", "read", "Lcommunity/flock/wirespec/plugin/io/FilePath;", "write", "", "string", "wirespecSources", "Lcommunity/flock/wirespec/plugin/io/WirespecFileError;", "Larrow/core/NonEmptySet;", "Lcommunity/flock/wirespec/plugin/io/Source;", "Lcommunity/flock/wirespec/plugin/io/Source$Type$Wirespec;", "Lcommunity/flock/wirespec/plugin/io/Directory;", "isRegularFile", "path", "isWirespecFile", "extension", "getExtension", "(Lkotlinx/io/files/Path;)Ljava/lang/String;", "arguments"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncommunity/flock/wirespec/plugin/io/UtilsKt\n+ 2 Either.kt\narrow/core/EitherKt\n+ 3 Either.kt\narrow/core/Either\n+ 4 predef.kt\narrow/core/PredefKt\n+ 5 Builders.kt\narrow/core/raise/RaiseKt__BuildersKt\n+ 6 Fold.kt\narrow/core/raise/RaiseKt__FoldKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 8 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1749#2,2:78\n603#3,6:80\n609#3:87\n6#4:86\n37#5:88\n37#5:110\n37#5:133\n109#6,5:89\n134#6,16:94\n109#6,5:111\n134#6,16:116\n109#6,5:134\n134#6,8:139\n142#6,8:161\n1#7:132\n774#8:147\n865#8,2:148\n774#8:150\n865#8,2:151\n1557#8:153\n1628#8,3:154\n1557#8:157\n1628#8,3:158\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncommunity/flock/wirespec/plugin/io/UtilsKt\n*L\n15#1:78,2\n15#1:80,6\n15#1:87\n15#1:86\n17#1:88\n34#1:110\n60#1:133\n17#1:89,5\n17#1:94,16\n34#1:111,5\n34#1:116,16\n60#1:134,5\n60#1:139,8\n60#1:161,8\n63#1:147\n63#1:148,2\n64#1:150\n64#1:151,2\n65#1:153\n65#1:154,3\n66#1:157\n66#1:158,3\n*E\n"})
public final class UtilsKt {
    public static final <B> B or(@NotNull Either<? extends IOError, ? extends B> $this$or, @NotNull Function1 errorFn) {
        Intrinsics.checkNotNullParameter($this$or, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)errorFn, (String)"errorFn");
        Either<? extends IOError, ? extends B> $this$getOrElse$iv = $this$or;
        boolean $i$f$getOrElse = false;
        Either<? extends IOError, ? extends B> this_$iv$iv = $this$getOrElse$iv;
        boolean $i$f$fold = false;
        Either<? extends IOError, ? extends B> either = this_$iv$iv;
        if (!(either instanceof Either.Right)) {
            if (either instanceof Either.Left) {
                IOError it = (IOError)((Either.Left)this_$iv$iv).getValue();
                boolean bl = false;
                errorFn.invoke((Object)it.getMessage());
                throw new KotlinNothingValueException();
            }
            throw new NoWhenBranchMatchedException();
        }
        Object p0$iv = ((Either.Right)this_$iv$iv).getValue();
        boolean bl = false;
        boolean $i$f$identity = false;
        return (B)p0$iv;
    }

    @NotNull
    public static final Either<IOError, FullPath> getFullPath(@Nullable String input, boolean createIfNotExists) {
        Either either;
        boolean $i$f$either = false;
        boolean $i$f$_foldOrThrow = false;
        boolean $i$f$_fold = false;
        DefaultRaise raise$iv$iv$iv = new DefaultRaise(false);
        try {
            FullPath fullPath;
            Raise $this$either_u24lambda_u240$iv = (Raise)raise$iv$iv$iv;
            boolean bl = false;
            Raise $this$getFullPath_u24lambda_u241 = $this$either_u24lambda_u240$iv;
            boolean bl2 = false;
            if (input == null) {
                fullPath = null;
            } else if (StringsKt.startsWith$default((String)input, (String)"classpath:", (boolean)false, (int)2, null)) {
                fullPath = ClassPath.box-impl(ClassPath.constructor-impl(StringsKt.substringAfter$default((String)input, (String)"classpath:", null, (int)2, null)));
            } else {
                Path path = UtilsKt.createIfNotExists(PathsJvmKt.Path((String)input), createIfNotExists);
                FileMetadata fileMetadata = FileSystemJvmKt.SystemFileSystem.metadataOrNull(path);
                if (fileMetadata == null) {
                    $this$getFullPath_u24lambda_u241.raise((Object)new CannotAccessFileOrDirectory(input));
                    throw new KotlinNothingValueException();
                }
                FileMetadata meta = fileMetadata;
                String pathString = path.toString();
                if (meta.isDirectory()) {
                    fullPath = DirectoryPath.box-impl(DirectoryPath.constructor-impl(pathString));
                } else if (meta.isRegularFile()) {
                    fullPath = FilePath.Companion.invoke(pathString);
                } else {
                    $this$getFullPath_u24lambda_u241.raise((Object)new IsNotAFileOrDirectory(pathString));
                    throw new KotlinNothingValueException();
                }
            }
            ClassPath res$iv$iv$iv = fullPath;
            raise$iv$iv$iv.complete();
            ClassPath it$iv = res$iv$iv$iv;
            boolean bl3 = false;
            either = (Either)new Either.Right(it$iv);
        }
        catch (RaiseCancellationException e$iv$iv$iv) {
            raise$iv$iv$iv.complete();
            Object it$iv = RaiseKt.raisedOrRethrow((CancellationException)((CancellationException)((Object)e$iv$iv$iv)), (DefaultRaise)raise$iv$iv$iv);
            boolean bl = false;
            either = (Either)new Either.Left(it$iv);
        }
        catch (Throwable e$iv$iv$iv) {
            raise$iv$iv$iv.complete();
            Throwable it$iv$iv = NonFatalOrThrowKt.nonFatalOrThrow((Throwable)e$iv$iv$iv);
            boolean bl = false;
            throw it$iv$iv;
        }
        return either;
    }

    public static /* synthetic */ Either getFullPath$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UtilsKt.getFullPath(string, bl);
    }

    @NotNull
    public static final Either<IOError, DirectoryPath> getOutPutPath(@NotNull FullPath inputPath, @Nullable String output) {
        Either either;
        Intrinsics.checkNotNullParameter((Object)inputPath, (String)"inputPath");
        boolean $i$f$either = false;
        boolean $i$f$_foldOrThrow = false;
        boolean $i$f$_fold = false;
        DefaultRaise raise$iv$iv$iv = new DefaultRaise(false);
        try {
            String string;
            Raise $this$either_u24lambda_u240$iv = (Raise)raise$iv$iv$iv;
            boolean bl = false;
            Raise $this$getOutPutPath_u24lambda_u242 = $this$either_u24lambda_u240$iv;
            boolean bl2 = false;
            FullPath it = (FullPath)$this$getOutPutPath_u24lambda_u242.bind(UtilsKt.getFullPath(output, true));
            if (it == null) {
                string = DirectoryPath.constructor-impl(DefinitionsKt.path(inputPath) + "/out");
            } else if (it instanceof DirectoryPath) {
                string = ((DirectoryPath)it).unbox-impl();
            } else {
                if (it instanceof FilePath || it instanceof ClassPath) {
                    $this$getOutPutPath_u24lambda_u242.raise((Object)new OutputShouldBeADirectory());
                    throw new KotlinNothingValueException();
                }
                throw new NoWhenBranchMatchedException();
            }
            DirectoryPath res$iv$iv$iv = DirectoryPath.box-impl(string);
            raise$iv$iv$iv.complete();
            DirectoryPath it$iv = res$iv$iv$iv;
            boolean bl3 = false;
            either = (Either)new Either.Right((Object)it$iv);
        }
        catch (RaiseCancellationException e$iv$iv$iv) {
            raise$iv$iv$iv.complete();
            Object it$iv = RaiseKt.raisedOrRethrow((CancellationException)((CancellationException)((Object)e$iv$iv$iv)), (DefaultRaise)raise$iv$iv$iv);
            boolean bl = false;
            either = (Either)new Either.Left(it$iv);
        }
        catch (Throwable e$iv$iv$iv) {
            raise$iv$iv$iv.complete();
            Throwable it$iv$iv = NonFatalOrThrowKt.nonFatalOrThrow((Throwable)e$iv$iv$iv);
            boolean bl = false;
            throw it$iv$iv;
        }
        return either;
    }

    @NotNull
    public static final Path createIfNotExists(@NotNull Path $this$createIfNotExists, boolean create) {
        Path path;
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$createIfNotExists, (String)"<this>");
            Path it = path = $this$createIfNotExists;
            boolean bl = false;
            if (!create || FileSystemJvmKt.SystemFileSystem.exists($this$createIfNotExists)) break block0;
            FileSystemJvmKt.SystemFileSystem.createDirectories($this$createIfNotExists, true);
        }
        return path;
    }

    public static /* synthetic */ Path createIfNotExists$default(Path path, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return UtilsKt.createIfNotExists(path, bl);
    }

    @NotNull
    public static final String read(@NotNull FilePath $this$read) {
        Intrinsics.checkNotNullParameter((Object)$this$read, (String)"<this>");
        Path it = PathsJvmKt.Path((String)$this$read.toString());
        boolean bl = false;
        return Utf8Kt.readString((kotlinx.io.Source)CoreKt.buffered((RawSource)FileSystemJvmKt.SystemFileSystem.source(it)));
    }

    public static final void write(@NotNull FilePath $this$write, @NotNull String string) {
        Sink sink;
        Path path;
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Path it = path = PathsJvmKt.Path((String)$this$write.toString());
        boolean bl = false;
        Path path2 = it.getParent();
        if (path2 != null) {
            UtilsKt.createIfNotExists$default(path2, false, 1, null);
        }
        it = path;
        boolean bl2 = false;
        Sink $this$write_u24lambda_u247_u24lambda_u246 = sink = CoreKt.buffered((RawSink)FileSystem.sink$default((FileSystem)FileSystemJvmKt.SystemFileSystem, (Path)it, (boolean)false, (int)2, null));
        boolean bl3 = false;
        Utf8Kt.writeString$default((Sink)$this$write_u24lambda_u247_u24lambda_u246, (String)string, (int)0, (int)0, (int)6, null);
        sink.flush();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Either<WirespecFileError, NonEmptySet<Source<Source.Type.Wirespec>>> wirespecSources(@NotNull Directory $this$wirespecSources) {
        Either either;
        Intrinsics.checkNotNullParameter((Object)$this$wirespecSources, (String)"<this>");
        boolean $i$f$either = false;
        boolean $i$f$_foldOrThrow = false;
        boolean $i$f$_fold = false;
        DefaultRaise raise$iv$iv$iv = new DefaultRaise(false);
        try {
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Path p0;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Raise $this$either_u24lambda_u240$iv = (Raise)raise$iv$iv$iv;
            boolean bl = false;
            Raise $this$wirespecSources_u24lambda_u2412 = $this$either_u24lambda_u240$iv;
            boolean bl2 = false;
            Object object = PathsJvmKt.Path((String)$this$wirespecSources.getPath-OtvJppA());
            FileSystem fileSystem = FileSystemJvmKt.SystemFileSystem;
            Path p02 = object;
            boolean bl3 = false;
            boolean $i$f$wirespecSources$lambda$12$stub_for_inlining = false;
            object = fileSystem.list(p02);
            boolean $i$f$filter = false;
            p02 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                p0 = (Path)element$iv$iv;
                boolean bl4 = false;
                boolean $i$f$wirespecSources$lambda$12$stub_for_inlining$8 = false;
                if (!UtilsKt.isRegularFile(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                p0 = (Path)element$iv$iv;
                boolean bl5 = false;
                boolean $i$f$wirespecSources$lambda$12$stub_for_inlining$9 = false;
                if (!UtilsKt.isWirespecFile(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                p0 = (Path)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl6 = false;
                collection.add(TuplesKt.to((Object)FilePath.Companion.invoke(it.toString()), (Object)Utf8Kt.readString((kotlinx.io.Source)CoreKt.buffered((RawSource)FileSystemJvmKt.SystemFileSystem.source((Path)it)))));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl7 = false;
                FilePath path = (FilePath)pair.component1();
                String source = (String)pair.component2();
                collection.add(new Source(path.getName-dJMPy20(), source, null));
            }
            Set set = NonEmptySetKt.toNonEmptySetOrNull((Iterable)((List)destination$iv$iv));
            if (set == null) {
                $this$wirespecSources_u24lambda_u2412.raise((Object)new WirespecFileError());
                throw new KotlinNothingValueException();
            }
            NonEmptySet res$iv$iv$iv = NonEmptySet.box-impl((Set)set);
            raise$iv$iv$iv.complete();
            NonEmptySet it$iv = res$iv$iv$iv;
            boolean bl8 = false;
            either = (Either)new Either.Right((Object)it$iv);
        }
        catch (RaiseCancellationException e$iv$iv$iv) {
            raise$iv$iv$iv.complete();
            Object it$iv = RaiseKt.raisedOrRethrow((CancellationException)((CancellationException)((Object)e$iv$iv$iv)), (DefaultRaise)raise$iv$iv$iv);
            boolean bl = false;
            either = (Either)new Either.Left(it$iv);
        }
        catch (Throwable e$iv$iv$iv) {
            raise$iv$iv$iv.complete();
            Throwable it$iv$iv = NonFatalOrThrowKt.nonFatalOrThrow((Throwable)e$iv$iv$iv);
            boolean bl = false;
            throw it$iv$iv;
        }
        return either;
    }

    private static final boolean isRegularFile(Path path) {
        FileMetadata fileMetadata = FileSystemJvmKt.SystemFileSystem.metadataOrNull(path);
        return fileMetadata != null ? fileMetadata.isRegularFile() : false;
    }

    private static final boolean isWirespecFile(Path path) {
        return Intrinsics.areEqual((Object)UtilsKt.getExtension(path), (Object)FileExtension.Wirespec.getValue());
    }

    private static final String getExtension(Path $this$extension) {
        return StringsKt.substringAfterLast((String)$this$extension.getName(), (char)'.', (String)"");
    }
}

