/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.commons.configuration2;

import consulting.freiheitsgrade.patched.commons.configuration2.AbstractYAMLBasedConfiguration;
import consulting.freiheitsgrade.patched.commons.configuration2.FileBasedConfiguration;
import consulting.freiheitsgrade.patched.commons.configuration2.HierarchicalConfiguration;
import consulting.freiheitsgrade.patched.commons.configuration2.ex.ConfigurationException;
import consulting.freiheitsgrade.patched.commons.configuration2.io.InputStreamSupport;
import consulting.freiheitsgrade.patched.commons.configuration2.tree.ImmutableNode;
import consulting.freiheitsgrade.patched.dependencies.com.fasterxml.jackson.databind.JavaType;
import consulting.freiheitsgrade.patched.dependencies.com.fasterxml.jackson.databind.ObjectMapper;
import consulting.freiheitsgrade.patched.dependencies.com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;

public class JSONConfiguration
extends AbstractYAMLBasedConfiguration
implements FileBasedConfiguration,
InputStreamSupport {
    private final ObjectMapper mapper = new ObjectMapper();
    private final MapType type = this.mapper.getTypeFactory().constructMapType(Map.class, String.class, Object.class);

    public JSONConfiguration() {
    }

    public JSONConfiguration(HierarchicalConfiguration<ImmutableNode> c) {
        super(c);
    }

    @Override
    public void read(Reader in) throws ConfigurationException {
        try {
            Map map = (Map)this.mapper.readValue(in, (JavaType)this.type);
            this.load(map);
        }
        catch (Exception e) {
            JSONConfiguration.rethrowException(e);
        }
    }

    @Override
    public void write(Writer out) throws ConfigurationException, IOException {
        this.mapper.writer().writeValue(out, this.constructMap(this.getNodeModel().getNodeHandler().getRootNode()));
    }

    @Override
    public void read(InputStream in) throws ConfigurationException {
        try {
            Map map = (Map)this.mapper.readValue(in, (JavaType)this.type);
            this.load(map);
        }
        catch (Exception e) {
            JSONConfiguration.rethrowException(e);
        }
    }
}

