/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.commons.configuration2;

import consulting.freiheitsgrade.patched.commons.configuration2.BaseConfiguration;
import consulting.freiheitsgrade.patched.commons.configuration2.Configuration;
import consulting.freiheitsgrade.patched.commons.configuration2.MapConfiguration;
import consulting.freiheitsgrade.patched.commons.configuration2.PropertiesConfiguration;
import consulting.freiheitsgrade.patched.commons.configuration2.XMLPropertiesConfiguration;
import consulting.freiheitsgrade.patched.commons.configuration2.ex.ConfigurationException;
import consulting.freiheitsgrade.patched.commons.configuration2.io.FileBased;
import consulting.freiheitsgrade.patched.commons.configuration2.io.FileHandler;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.logging.Log;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.logging.LogFactory;
import java.util.Iterator;

public class SystemConfiguration
extends MapConfiguration {
    private static Log log = LogFactory.getLog(SystemConfiguration.class);

    public SystemConfiguration() {
        super(System.getProperties());
    }

    public static void setSystemProperties(String fileName) throws ConfigurationException {
        SystemConfiguration.setSystemProperties(null, fileName);
    }

    public static void setSystemProperties(String basePath, String fileName) throws ConfigurationException {
        BaseConfiguration config = fileName.endsWith(".xml") ? new XMLPropertiesConfiguration() : new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)((Object)config));
        handler.setBasePath(basePath);
        handler.setFileName(fileName);
        handler.load();
        SystemConfiguration.setSystemProperties(config);
    }

    public static void setSystemProperties(Configuration systemConfig) {
        Iterator<String> iter = systemConfig.getKeys();
        while (iter.hasNext()) {
            String key = iter.next();
            String value = (String)systemConfig.getProperty(key);
            if (log.isDebugEnabled()) {
                log.debug("Setting system property " + key + " to " + value);
            }
            System.setProperty(key, value);
        }
    }

    @Override
    protected Iterator<String> getKeysInternal() {
        return System.getProperties().stringPropertyNames().iterator();
    }
}

