/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.commons.configuration2;

import consulting.freiheitsgrade.patched.commons.configuration2.AbstractYAMLBasedConfiguration;
import consulting.freiheitsgrade.patched.commons.configuration2.FileBasedConfiguration;
import consulting.freiheitsgrade.patched.commons.configuration2.HierarchicalConfiguration;
import consulting.freiheitsgrade.patched.commons.configuration2.ex.ConfigurationException;
import consulting.freiheitsgrade.patched.commons.configuration2.ex.ConfigurationRuntimeException;
import consulting.freiheitsgrade.patched.commons.configuration2.io.InputStreamSupport;
import consulting.freiheitsgrade.patched.commons.configuration2.tree.ImmutableNode;
import consulting.freiheitsgrade.patched.dependencies.org.yaml.snakeyaml.DumperOptions;
import consulting.freiheitsgrade.patched.dependencies.org.yaml.snakeyaml.LoaderOptions;
import consulting.freiheitsgrade.patched.dependencies.org.yaml.snakeyaml.Yaml;
import consulting.freiheitsgrade.patched.dependencies.org.yaml.snakeyaml.constructor.BaseConstructor;
import consulting.freiheitsgrade.patched.dependencies.org.yaml.snakeyaml.constructor.Constructor;
import consulting.freiheitsgrade.patched.dependencies.org.yaml.snakeyaml.representer.Representer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;

public class YAMLConfiguration
extends AbstractYAMLBasedConfiguration
implements FileBasedConfiguration,
InputStreamSupport {
    public YAMLConfiguration() {
    }

    public YAMLConfiguration(HierarchicalConfiguration<ImmutableNode> c) {
        super(c);
    }

    @Override
    public void read(Reader in) throws ConfigurationException {
        try {
            Yaml yaml = YAMLConfiguration.createYamlForReading(new LoaderOptions());
            Map map = (Map)yaml.load(in);
            this.load(map);
        }
        catch (Exception e) {
            YAMLConfiguration.rethrowException(e);
        }
    }

    public void read(Reader in, LoaderOptions options) throws ConfigurationException {
        try {
            Yaml yaml = YAMLConfiguration.createYamlForReading(options);
            Map map = (Map)yaml.load(in);
            this.load(map);
        }
        catch (Exception e) {
            YAMLConfiguration.rethrowException(e);
        }
    }

    @Override
    public void write(Writer out) throws ConfigurationException, IOException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.dump(out, options);
    }

    public void dump(Writer out, DumperOptions options) throws ConfigurationException, IOException {
        Yaml yaml = new Yaml(options);
        yaml.dump(this.constructMap(this.getNodeModel().getNodeHandler().getRootNode()), out);
    }

    @Override
    public void read(InputStream in) throws ConfigurationException {
        try {
            Yaml yaml = YAMLConfiguration.createYamlForReading(new LoaderOptions());
            Map map = (Map)yaml.load(in);
            this.load(map);
        }
        catch (Exception e) {
            YAMLConfiguration.rethrowException(e);
        }
    }

    public void read(InputStream in, LoaderOptions options) throws ConfigurationException {
        try {
            Yaml yaml = YAMLConfiguration.createYamlForReading(options);
            Map map = (Map)yaml.load(in);
            this.load(map);
        }
        catch (Exception e) {
            YAMLConfiguration.rethrowException(e);
        }
    }

    private static Yaml createYamlForReading(LoaderOptions options) {
        return new Yaml((BaseConstructor)YAMLConfiguration.createClassLoadingDisablingConstructor(), new Representer(), new DumperOptions(), options);
    }

    private static Constructor createClassLoadingDisablingConstructor() {
        return new Constructor(){

            @Override
            protected Class<?> getClassForName(String name) {
                throw new ConfigurationRuntimeException("Class instantiation is disabled.");
            }
        };
    }
}

