/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.commons.configuration2.builder;

import consulting.freiheitsgrade.patched.commons.configuration2.builder.FileBasedConfigurationBuilder;
import consulting.freiheitsgrade.patched.commons.configuration2.event.ConfigurationEvent;
import consulting.freiheitsgrade.patched.commons.configuration2.event.EventListener;
import consulting.freiheitsgrade.patched.commons.configuration2.ex.ConfigurationException;
import consulting.freiheitsgrade.patched.commons.configuration2.io.FileHandler;
import consulting.freiheitsgrade.patched.commons.configuration2.io.FileHandlerListenerAdapter;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.logging.Log;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.logging.LogFactory;

class AutoSaveListener
extends FileHandlerListenerAdapter
implements EventListener<ConfigurationEvent> {
    private final Log log = LogFactory.getLog(this.getClass());
    private final FileBasedConfigurationBuilder<?> builder;
    private FileHandler handler;
    private int loading;

    public AutoSaveListener(FileBasedConfigurationBuilder<?> bldr) {
        this.builder = bldr;
    }

    @Override
    public void onEvent(ConfigurationEvent event) {
        if (this.autoSaveRequired(event)) {
            try {
                this.builder.save();
            }
            catch (ConfigurationException ce) {
                this.log.warn("Auto save failed!", ce);
            }
        }
    }

    @Override
    public synchronized void loading(FileHandler handler) {
        ++this.loading;
    }

    @Override
    public synchronized void loaded(FileHandler handler) {
        --this.loading;
    }

    public synchronized void updateFileHandler(FileHandler fh) {
        if (this.handler != null) {
            this.handler.removeFileHandlerListener(this);
        }
        if (fh != null) {
            fh.addFileHandlerListener(this);
        }
        this.handler = fh;
    }

    private synchronized boolean inLoadOperation() {
        return this.loading > 0;
    }

    private boolean autoSaveRequired(ConfigurationEvent event) {
        return !event.isBeforeUpdate() && !this.inLoadOperation();
    }
}

