/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.com.squareup.okhttp;

import consulting.freiheitsgrade.patched.dependencies.com.squareup.okhttp.Call;
import consulting.freiheitsgrade.patched.dependencies.com.squareup.okhttp.internal.Util;
import consulting.freiheitsgrade.patched.dependencies.com.squareup.okhttp.internal.http.HttpEngine;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class Dispatcher {
    private int maxRequests = 64;
    private int maxRequestsPerHost = 5;
    private ExecutorService executorService;
    private final Deque<Call.AsyncCall> readyCalls = new ArrayDeque<Call.AsyncCall>();
    private final Deque<Call.AsyncCall> runningCalls = new ArrayDeque<Call.AsyncCall>();
    private final Deque<Call> executedCalls = new ArrayDeque<Call>();

    public Dispatcher(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public Dispatcher() {
    }

    public synchronized ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkHttp Dispatcher", false));
        }
        return this.executorService;
    }

    public synchronized void setMaxRequests(int maxRequests) {
        if (maxRequests < 1) {
            throw new IllegalArgumentException("max < 1: " + maxRequests);
        }
        this.maxRequests = maxRequests;
        this.promoteCalls();
    }

    public synchronized int getMaxRequests() {
        return this.maxRequests;
    }

    public synchronized void setMaxRequestsPerHost(int maxRequestsPerHost) {
        if (maxRequestsPerHost < 1) {
            throw new IllegalArgumentException("max < 1: " + maxRequestsPerHost);
        }
        this.maxRequestsPerHost = maxRequestsPerHost;
        this.promoteCalls();
    }

    public synchronized int getMaxRequestsPerHost() {
        return this.maxRequestsPerHost;
    }

    synchronized void enqueue(Call.AsyncCall call) {
        if (this.runningCalls.size() < this.maxRequests && this.runningCallsForHost(call) < this.maxRequestsPerHost) {
            this.runningCalls.add(call);
            this.getExecutorService().execute(call);
        } else {
            this.readyCalls.add(call);
        }
    }

    public synchronized void cancel(Object tag) {
        for (Call.AsyncCall asyncCall : this.readyCalls) {
            if (!Util.equal(tag, asyncCall.tag())) continue;
            asyncCall.cancel();
        }
        for (Call.AsyncCall asyncCall : this.runningCalls) {
            if (!Util.equal(tag, asyncCall.tag())) continue;
            asyncCall.get().canceled = true;
            HttpEngine engine = asyncCall.get().engine;
            if (engine == null) continue;
            engine.cancel();
        }
        for (Call call : this.executedCalls) {
            if (!Util.equal(tag, call.tag())) continue;
            call.cancel();
        }
    }

    synchronized void finished(Call.AsyncCall call) {
        if (!this.runningCalls.remove(call)) {
            throw new AssertionError((Object)"AsyncCall wasn't running!");
        }
        this.promoteCalls();
    }

    private void promoteCalls() {
        if (this.runningCalls.size() >= this.maxRequests) {
            return;
        }
        if (this.readyCalls.isEmpty()) {
            return;
        }
        Iterator<Call.AsyncCall> i = this.readyCalls.iterator();
        while (i.hasNext()) {
            Call.AsyncCall call = i.next();
            if (this.runningCallsForHost(call) < this.maxRequestsPerHost) {
                i.remove();
                this.runningCalls.add(call);
                this.getExecutorService().execute(call);
            }
            if (this.runningCalls.size() < this.maxRequests) continue;
            return;
        }
    }

    private int runningCallsForHost(Call.AsyncCall call) {
        int result = 0;
        for (Call.AsyncCall c : this.runningCalls) {
            if (!c.host().equals(call.host())) continue;
            ++result;
        }
        return result;
    }

    synchronized void executed(Call call) {
        this.executedCalls.add(call);
    }

    synchronized void finished(Call call) {
        if (!this.executedCalls.remove(call)) {
            throw new AssertionError((Object)"Call wasn't in-flight!");
        }
    }

    public synchronized int getRunningCallCount() {
        return this.runningCalls.size();
    }

    public synchronized int getQueuedCallCount() {
        return this.readyCalls.size();
    }
}

