/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal.AbstractExecutor;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal.BooleanGetExecutor;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal.DuckGetExecutor;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal.DuckSetExecutor;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal.ListGetExecutor;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal.ListSetExecutor;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal.MapGetExecutor;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal.MapSetExecutor;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal.MethodExecutor;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal.PropertyGetExecutor;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal.PropertySetExecutor;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal.introspection.IntrospectorBase;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal.introspection.MethodKey;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.logging.Log;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Introspector {
    protected final Log rlog;
    private volatile SoftReference<IntrospectorBase> ref;

    protected Introspector(Log log) {
        this.rlog = log;
        this.ref = new SoftReference<Object>(null);
    }

    protected Integer toInteger(Object arg) {
        if (arg == null) {
            return null;
        }
        if (arg instanceof Number) {
            return ((Number)arg).intValue();
        }
        try {
            return Integer.valueOf(arg.toString());
        }
        catch (NumberFormatException xnumber) {
            return null;
        }
    }

    protected String toString(Object arg) {
        return arg == null ? null : arg.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IntrospectorBase base() {
        IntrospectorBase intro = this.ref.get();
        if (intro == null) {
            Introspector introspector = this;
            synchronized (introspector) {
                intro = this.ref.get();
                if (intro == null) {
                    intro = new IntrospectorBase(this.rlog);
                    this.ref = new SoftReference<IntrospectorBase>(intro);
                }
            }
        }
        return intro;
    }

    public void setClassLoader(ClassLoader loader) {
        this.base().setLoader(loader);
    }

    public Class<?> getClassByName(String className) {
        return this.base().getClassByName(className);
    }

    public final Field getField(Class<?> c, String key) {
        return this.base().getField(c, key);
    }

    public final String[] getFieldNames(Class<?> c) {
        return this.base().getFieldNames(c);
    }

    public final Method getMethod(Class<?> c, String name, Object[] params) {
        return this.base().getMethod(c, new MethodKey(name, params));
    }

    public final Method getMethod(Class<?> c, MethodKey key) {
        return this.base().getMethod(c, key);
    }

    public final String[] getMethodNames(Class<?> c) {
        return this.base().getMethodNames(c);
    }

    public final Method[] getMethods(Class<?> c, String methodName) {
        return this.base().getMethods(c, methodName);
    }

    public final Constructor<?> getConstructor(Object ctorHandle, Object[] args) {
        String className = null;
        Class clazz = null;
        if (ctorHandle instanceof Class) {
            clazz = (Class)ctorHandle;
            className = clazz.getName();
        } else if (ctorHandle != null) {
            className = ctorHandle.toString();
        } else {
            return null;
        }
        return this.base().getConstructor(clazz, new MethodKey(className, args));
    }

    public final AbstractExecutor.Method getMethodExecutor(Object obj, String name, Object[] args) {
        MethodExecutor me = new MethodExecutor(this, obj, name, args);
        return me.isAlive() ? me : null;
    }

    public final AbstractExecutor.Get getGetExecutor(Object obj, Object identifier) {
        AbstractExecutor.Get executor;
        Class<?> claz = obj.getClass();
        String property = this.toString(identifier);
        if (property != null) {
            executor = new PropertyGetExecutor(this, claz, property);
            if (executor.isAlive()) {
                return executor;
            }
            executor = new BooleanGetExecutor(this, claz, property);
            if (executor.isAlive()) {
                return executor;
            }
        }
        if ((executor = new MapGetExecutor(this, claz, identifier)).isAlive()) {
            return executor;
        }
        Integer index = this.toInteger(identifier);
        if (index != null && (executor = new ListGetExecutor(this, claz, index)).isAlive()) {
            return executor;
        }
        executor = new DuckGetExecutor(this, claz, identifier);
        if (executor.isAlive()) {
            return executor;
        }
        executor = new DuckGetExecutor(this, claz, property);
        if (executor.isAlive()) {
            return executor;
        }
        return null;
    }

    public final AbstractExecutor.Set getSetExecutor(Object obj, Object identifier, Object arg) {
        AbstractExecutor.Set executor;
        Class<?> claz = obj.getClass();
        String property = this.toString(identifier);
        if (property != null && (executor = new PropertySetExecutor(this, claz, property, arg)).isAlive()) {
            return executor;
        }
        executor = new MapSetExecutor(this, claz, identifier, arg);
        if (executor.isAlive()) {
            return executor;
        }
        Integer index = this.toInteger(identifier);
        if (index != null && (executor = new ListSetExecutor(this, claz, index, arg)).isAlive()) {
            return executor;
        }
        executor = new DuckSetExecutor(this, claz, identifier, arg);
        if (executor.isAlive()) {
            return executor;
        }
        executor = new DuckSetExecutor(this, claz, property, arg);
        if (executor.isAlive()) {
            return executor;
        }
        return null;
    }
}

