/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal.AbstractExecutor;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal.Introspector;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListSetExecutor
extends AbstractExecutor.Set {
    private static final Method ARRAY_SET = ListSetExecutor.initMarker(Array.class, "set", Object.class, Integer.TYPE, Object.class);
    private static final Method LIST_SET = ListSetExecutor.initMarker(List.class, "set", Integer.TYPE, Object.class);
    private final Integer property;

    public ListSetExecutor(Introspector is, Class<?> clazz, Integer key, Object value) {
        super(clazz, ListSetExecutor.discover(clazz));
        this.property = key;
    }

    @Override
    public Object getTargetProperty() {
        return this.property;
    }

    @Override
    public Object execute(Object obj, Object value) {
        if (this.method == ARRAY_SET) {
            Array.set(obj, this.property, value);
        } else {
            List list = (List)obj;
            list.set(this.property, value);
        }
        return value;
    }

    @Override
    public Object tryExecute(Object obj, Object key, Object value) {
        if (obj != null && this.method != null && this.objectClass.equals(obj.getClass()) && key instanceof Integer) {
            if (this.method == ARRAY_SET) {
                Array.set(obj, (Integer)key, value);
            } else {
                List list = (List)obj;
                list.set((Integer)key, value);
            }
            return value;
        }
        return TRY_FAILED;
    }

    static Method discover(Class<?> clazz) {
        if (clazz.isArray()) {
            return ARRAY_SET;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return LIST_SET;
        }
        return null;
    }
}

