/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal.introspection;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal.introspection.MethodKey;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MethodMap {
    private final Map<String, List<Method>> methodByNameMap = new HashMap<String, List<Method>>();

    MethodMap() {
    }

    public synchronized void add(Method method) {
        String methodName = method.getName();
        List<Method> l = this.methodByNameMap.get(methodName);
        if (l == null) {
            l = new ArrayList<Method>();
            this.methodByNameMap.put(methodName, l);
        }
        l.add(method);
    }

    public synchronized List<Method> get(String key) {
        return this.methodByNameMap.get(key);
    }

    public synchronized String[] names() {
        Set<String> set = this.methodByNameMap.keySet();
        return set.toArray(new String[set.size()]);
    }

    public Method find(String methodName, Object[] args) throws MethodKey.AmbiguousException {
        return this.find(new MethodKey(methodName, args));
    }

    Method find(MethodKey methodKey) throws MethodKey.AmbiguousException {
        List<Method> methodList = this.get(methodKey.getMethod());
        if (methodList == null) {
            return null;
        }
        return methodKey.getMostSpecificMethod(methodList);
    }
}

