/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.introspection;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.JexlInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.introspection.JexlMethod;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.introspection.JexlPropertyGet;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.introspection.JexlPropertySet;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.introspection.Sandbox;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.introspection.UberspectImpl;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.logging.Log;

public class SandboxUberspectImpl
extends UberspectImpl {
    protected final Sandbox sandbox;

    public SandboxUberspectImpl(Log runtimeLogger, Sandbox theSandbox) {
        super(runtimeLogger);
        if (theSandbox == null) {
            throw new NullPointerException("sandbox can not be null");
        }
        this.sandbox = theSandbox;
    }

    public void setLoader(ClassLoader cloader) {
        this.base().setLoader(cloader);
    }

    public JexlMethod getConstructorMethod(Object ctorHandle, Object[] args, JexlInfo info) {
        String className;
        if (ctorHandle instanceof Class) {
            Class clazz = (Class)ctorHandle;
            className = clazz.getName();
        } else if (ctorHandle != null) {
            className = ctorHandle.toString();
        } else {
            return null;
        }
        if (this.sandbox.execute(className, "") != null) {
            return super.getConstructorMethod(className, args, info);
        }
        return null;
    }

    public JexlMethod getMethod(Object obj, String method, Object[] args, JexlInfo info) {
        String actual;
        if (obj != null && method != null && (actual = this.sandbox.execute(obj.getClass().getName(), method)) != null) {
            return this.getMethodExecutor(obj, actual, args);
        }
        return null;
    }

    public JexlPropertyGet getPropertyGet(Object obj, Object identifier, JexlInfo info) {
        String actual;
        if (obj != null && identifier != null && (actual = this.sandbox.read(obj.getClass().getName(), identifier.toString())) != null) {
            return super.getPropertyGet(obj, actual, info);
        }
        return null;
    }

    public JexlPropertySet getPropertySet(Object obj, Object identifier, Object arg, JexlInfo info) {
        String actual;
        if (obj != null && identifier != null && (actual = this.sandbox.write(obj.getClass().getName(), identifier.toString())) != null) {
            return super.getPropertySet(obj, actual, arg, info);
        }
        return null;
    }
}

