/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.introspection;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.JexlException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.JexlInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal.AbstractExecutor;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal.ArrayIterator;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal.EnumerationIterator;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal.Introspector;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.internal.introspection.MethodKey;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.introspection.JexlMethod;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.introspection.JexlPropertyGet;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.introspection.JexlPropertySet;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jexl2.introspection.Uberspect;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.logging.Log;
import java.beans.IntrospectionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UberspectImpl
extends Introspector
implements Uberspect {
    public static final Object TRY_FAILED = AbstractExecutor.TRY_FAILED;

    public UberspectImpl(Log runtimeLogger) {
        super(runtimeLogger);
    }

    public void setLoader(ClassLoader cloader) {
        this.base().setLoader(cloader);
    }

    @Override
    public Iterator<?> getIterator(Object obj, JexlInfo info) {
        if (obj instanceof Iterator) {
            return (Iterator)obj;
        }
        if (obj.getClass().isArray()) {
            return new ArrayIterator(obj);
        }
        if (obj instanceof Map) {
            return ((Map)obj).values().iterator();
        }
        if (obj instanceof Enumeration) {
            return new EnumerationIterator((Enumeration)obj);
        }
        if (obj instanceof Iterable) {
            return ((Iterable)obj).iterator();
        }
        try {
            AbstractExecutor.Method it = this.getMethodExecutor(obj, "iterator", null);
            if (it != null && Iterator.class.isAssignableFrom(it.getReturnType())) {
                return (Iterator)it.execute(obj, null);
            }
        }
        catch (Exception xany) {
            throw new JexlException(info, "unable to generate iterator()", (Throwable)xany);
        }
        return null;
    }

    @Override
    public JexlMethod getMethod(Object obj, String method, Object[] args, JexlInfo info) {
        return this.getMethodExecutor(obj, method, args);
    }

    @Override
    @Deprecated
    public Constructor<?> getConstructor(Object ctorHandle, Object[] args, JexlInfo info) {
        return this.getConstructor(ctorHandle, args);
    }

    @Override
    public JexlMethod getConstructorMethod(Object ctorHandle, Object[] args, JexlInfo info) {
        Constructor<?> ctor = this.getConstructor(ctorHandle, args);
        if (ctor != null) {
            return new ConstructorMethod(ctor);
        }
        return null;
    }

    @Override
    public JexlPropertyGet getPropertyGet(Object obj, Object identifier, JexlInfo info) {
        Field field;
        JexlPropertyGet get = this.getGetExecutor(obj, identifier);
        if (get == null && obj != null && identifier != null && (get = this.getIndexedGet(obj, identifier.toString())) == null && (field = this.getField(obj, identifier.toString(), info)) != null) {
            return new FieldPropertyGet(field);
        }
        return get;
    }

    @Override
    public JexlPropertySet getPropertySet(Object obj, Object identifier, Object arg, JexlInfo info) {
        Field field;
        AbstractExecutor.Set set = this.getSetExecutor(obj, identifier, arg);
        if (set == null && obj != null && identifier != null && (field = this.getField(obj, identifier.toString(), info)) != null && !Modifier.isFinal(field.getModifiers()) && (arg == null || MethodKey.isInvocationConvertible(field.getType(), arg.getClass(), false))) {
            return new FieldPropertySet(field);
        }
        return set;
    }

    public Field getField(Object obj, String name, JexlInfo info) {
        Class<?> clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        return this.getField(clazz, name);
    }

    protected JexlPropertyGet getIndexedGet(Object object, String name) {
        if (object != null && name != null) {
            String base = name.substring(0, 1).toUpperCase() + name.substring(1);
            String container = name;
            Class<?> clazz = object.getClass();
            Method[] getters = this.getMethods(object.getClass(), "get" + base);
            Method[] setters = this.getMethods(object.getClass(), "set" + base);
            if (getters != null) {
                return new IndexedType(container, clazz, getters, setters);
            }
        }
        return null;
    }

    @Deprecated
    public static final class FieldPropertySet
    implements JexlPropertySet {
        private final Field field;

        public FieldPropertySet(Field theField) {
            this.field = theField;
        }

        public Object invoke(Object obj, Object arg) throws Exception {
            this.field.set(obj, arg);
            return arg;
        }

        public Object tryInvoke(Object obj, Object key, Object value) {
            if (obj.getClass().equals(this.field.getDeclaringClass()) && key.equals(this.field.getName()) && (value == null || MethodKey.isInvocationConvertible(this.field.getType(), value.getClass(), false))) {
                try {
                    this.field.set(obj, value);
                    return value;
                }
                catch (IllegalAccessException xill) {
                    return TRY_FAILED;
                }
            }
            return TRY_FAILED;
        }

        public boolean tryFailed(Object rval) {
            return rval == TRY_FAILED;
        }

        public boolean isCacheable() {
            return true;
        }
    }

    @Deprecated
    public static final class FieldPropertyGet
    implements JexlPropertyGet {
        private final Field field;

        public FieldPropertyGet(Field theField) {
            this.field = theField;
        }

        public Object invoke(Object obj) throws Exception {
            return this.field.get(obj);
        }

        public Object tryInvoke(Object obj, Object key) {
            if (obj.getClass().equals(this.field.getDeclaringClass()) && key.equals(this.field.getName())) {
                try {
                    return this.field.get(obj);
                }
                catch (IllegalAccessException xill) {
                    return TRY_FAILED;
                }
            }
            return TRY_FAILED;
        }

        public boolean tryFailed(Object rval) {
            return rval == TRY_FAILED;
        }

        public boolean isCacheable() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConstructorMethod
    implements JexlMethod {
        private final Constructor<?> ctor;

        private ConstructorMethod(Constructor<?> theCtor) {
            this.ctor = theCtor;
        }

        @Override
        public Object invoke(Object obj, Object[] params) throws Exception {
            Class<?> clazz = null;
            clazz = obj instanceof Class ? (Class<?>)obj : (obj != null ? UberspectImpl.this.getClassByName(obj.toString()) : this.ctor.getDeclaringClass());
            if (clazz.equals(this.ctor.getDeclaringClass())) {
                return this.ctor.newInstance(params);
            }
            throw new IntrospectionException("constructor resolution error");
        }

        @Override
        public Object tryInvoke(String name, Object obj, Object[] params) {
            Class<?> clazz = null;
            clazz = obj instanceof Class ? (Class<?>)obj : (obj != null ? UberspectImpl.this.getClassByName(obj.toString()) : this.ctor.getDeclaringClass());
            if (clazz.equals(this.ctor.getDeclaringClass()) && (name == null || name.equals(clazz.getName()))) {
                try {
                    return this.ctor.newInstance(params);
                }
                catch (InstantiationException xinstance) {
                    return TRY_FAILED;
                }
                catch (IllegalAccessException xaccess) {
                    return TRY_FAILED;
                }
                catch (IllegalArgumentException xargument) {
                    return TRY_FAILED;
                }
                catch (InvocationTargetException xinvoke) {
                    return TRY_FAILED;
                }
            }
            return TRY_FAILED;
        }

        @Override
        public boolean tryFailed(Object rval) {
            return rval == TRY_FAILED;
        }

        @Override
        public boolean isCacheable() {
            return true;
        }

        @Override
        public Class<?> getReturnType() {
            return this.ctor.getDeclaringClass();
        }
    }

    public static final class IndexedContainer {
        private final Object object;
        private final IndexedType type;

        private IndexedContainer(IndexedType theType, Object theObject) {
            this.type = theType;
            this.object = theObject;
        }

        public Object get(Object key) throws Exception {
            return this.type.invokeGet(this.object, key);
        }

        public Object set(Object key, Object value) throws Exception {
            return this.type.invokeSet(this.object, key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IndexedType
    implements JexlPropertyGet {
        private final String container;
        private final Class<?> clazz;
        private final Method[] getters;
        private final Method[] setters;

        IndexedType(String name, Class<?> c, Method[] gets, Method[] sets) {
            this.container = name;
            this.clazz = c;
            this.getters = gets;
            this.setters = sets;
        }

        @Override
        public Object invoke(Object obj) throws Exception {
            if (obj != null && this.clazz.equals(obj.getClass())) {
                return new IndexedContainer(this, obj);
            }
            throw new IntrospectionException("property resolution error");
        }

        @Override
        public Object tryInvoke(Object obj, Object key) {
            if (obj != null && key != null && this.clazz.equals(obj.getClass()) && this.container.equals(key.toString())) {
                return new IndexedContainer(this, obj);
            }
            return TRY_FAILED;
        }

        @Override
        public boolean tryFailed(Object rval) {
            return rval == TRY_FAILED;
        }

        @Override
        public boolean isCacheable() {
            return true;
        }

        private Object invokeGet(Object object, Object key) throws Exception {
            if (this.getters != null) {
                Object[] args = new Object[]{key};
                Method jm = this.getters.length == 1 ? this.getters[0] : new MethodKey(this.getters[0].getName(), args).getMostSpecificMethod(Arrays.asList(this.getters));
                if (jm != null) {
                    return jm.invoke(object, args);
                }
            }
            throw new IntrospectionException("property get error: " + object.getClass().toString() + "@" + key.toString());
        }

        private Object invokeSet(Object object, Object key, Object value) throws Exception {
            if (this.setters != null) {
                Object[] args = new Object[]{key, value};
                Method jm = this.setters.length == 1 ? this.setters[0] : new MethodKey(this.setters[0].getName(), args).getMostSpecificMethod(Arrays.asList(this.setters));
                if (jm != null) {
                    return jm.invoke(object, args);
                }
            }
            throw new IntrospectionException("property set error: " + object.getClass().toString() + "@" + key.toString());
        }
    }
}

