/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.NodeSet;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.Pointer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BasicNodeSet
implements NodeSet {
    private List pointers = new ArrayList();
    private List readOnlyPointers;
    private List nodes;
    private List values;

    public void add(Pointer pointer) {
        if (this.pointers.add(pointer)) {
            this.clearCacheLists();
        }
    }

    public void add(NodeSet nodeSet) {
        if (this.pointers.addAll(nodeSet.getPointers())) {
            this.clearCacheLists();
        }
    }

    public void remove(Pointer pointer) {
        if (this.pointers.remove(pointer)) {
            this.clearCacheLists();
        }
    }

    public synchronized List getPointers() {
        if (this.readOnlyPointers == null) {
            this.readOnlyPointers = Collections.unmodifiableList(this.pointers);
        }
        return this.readOnlyPointers;
    }

    public synchronized List getNodes() {
        if (this.nodes == null) {
            this.nodes = new ArrayList();
            for (int i = 0; i < this.pointers.size(); ++i) {
                Pointer pointer = (Pointer)this.pointers.get(i);
                this.nodes.add(pointer.getNode());
            }
            this.nodes = Collections.unmodifiableList(this.nodes);
        }
        return this.nodes;
    }

    public synchronized List getValues() {
        if (this.values == null) {
            this.values = new ArrayList();
            for (int i = 0; i < this.pointers.size(); ++i) {
                Pointer pointer = (Pointer)this.pointers.get(i);
                this.values.add(pointer.getValue());
            }
            this.values = Collections.unmodifiableList(this.values);
        }
        return this.values;
    }

    public String toString() {
        return this.pointers.toString();
    }

    private synchronized void clearCacheLists() {
        this.readOnlyPointers = null;
        this.nodes = null;
        this.values = null;
    }
}

