/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.JXPathBeanInfo;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class JXPathBasicBeanInfo
implements JXPathBeanInfo {
    private static final long serialVersionUID = -3863803443111484155L;
    private static final Comparator PROPERTY_DESCRIPTOR_COMPARATOR = new Comparator(){

        public int compare(Object left, Object right) {
            return ((PropertyDescriptor)left).getName().compareTo(((PropertyDescriptor)right).getName());
        }
    };
    private boolean atomic = false;
    private Class clazz;
    private Class dynamicPropertyHandlerClass;
    private transient PropertyDescriptor[] propertyDescriptors;
    private transient HashMap propertyDescriptorMap;
    static /* synthetic */ Class class$java$lang$Object;

    public JXPathBasicBeanInfo(Class clazz) {
        this.clazz = clazz;
    }

    public JXPathBasicBeanInfo(Class clazz, boolean atomic) {
        this.clazz = clazz;
        this.atomic = atomic;
    }

    public JXPathBasicBeanInfo(Class clazz, Class dynamicPropertyHandlerClass) {
        this.clazz = clazz;
        this.atomic = false;
        this.dynamicPropertyHandlerClass = dynamicPropertyHandlerClass;
    }

    public boolean isAtomic() {
        return this.atomic;
    }

    public boolean isDynamic() {
        return this.dynamicPropertyHandlerClass != null;
    }

    public synchronized PropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            if (this.clazz == (class$java$lang$Object == null ? (class$java$lang$Object = JXPathBasicBeanInfo.class$("java.lang.Object")) : class$java$lang$Object)) {
                this.propertyDescriptors = new PropertyDescriptor[0];
            } else {
                try {
                    BeanInfo bi = null;
                    bi = this.clazz.isInterface() ? Introspector.getBeanInfo(this.clazz) : Introspector.getBeanInfo(this.clazz, class$java$lang$Object == null ? (class$java$lang$Object = JXPathBasicBeanInfo.class$("java.lang.Object")) : class$java$lang$Object);
                    PropertyDescriptor[] pds = bi.getPropertyDescriptors();
                    PropertyDescriptor[] descriptors = new PropertyDescriptor[pds.length];
                    System.arraycopy(pds, 0, descriptors, 0, pds.length);
                    Arrays.sort(descriptors, PROPERTY_DESCRIPTOR_COMPARATOR);
                    this.propertyDescriptors = descriptors;
                }
                catch (IntrospectionException ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (this.propertyDescriptors.length == 0) {
            return this.propertyDescriptors;
        }
        PropertyDescriptor[] result = new PropertyDescriptor[this.propertyDescriptors.length];
        System.arraycopy(this.propertyDescriptors, 0, result, 0, this.propertyDescriptors.length);
        return result;
    }

    public synchronized PropertyDescriptor getPropertyDescriptor(String propertyName) {
        if (this.propertyDescriptorMap == null) {
            this.propertyDescriptorMap = new HashMap();
            PropertyDescriptor[] pds = this.getPropertyDescriptors();
            for (int i = 0; i < pds.length; ++i) {
                this.propertyDescriptorMap.put(pds[i].getName(), pds[i]);
            }
        }
        return (PropertyDescriptor)this.propertyDescriptorMap.get(propertyName);
    }

    public Class getDynamicPropertyHandlerClass() {
        return this.dynamicPropertyHandlerClass;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("BeanInfo [class = ");
        buffer.append(this.clazz.getName());
        if (this.isDynamic()) {
            buffer.append(", dynamic");
        }
        if (this.isAtomic()) {
            buffer.append(", atomic");
        }
        buffer.append(", properties = ");
        PropertyDescriptor[] jpds = this.getPropertyDescriptors();
        for (int i = 0; i < jpds.length; ++i) {
            buffer.append("\n    ");
            buffer.append(jpds[i].getPropertyType());
            buffer.append(": ");
            buffer.append(jpds[i].getName());
        }
        buffer.append("]");
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

