/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.JXPathContext;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.JXPathContextFactoryConfigurationError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public abstract class JXPathContextFactory {
    public static final String FACTORY_NAME_PROPERTY = "consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.JXPathContextFactory";
    private static final String DEFAULT_FACTORY_CLASS = "consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.JXPathContextFactoryReferenceImpl";
    private static String factoryImplName = null;
    private static boolean debug = false;
    static /* synthetic */ Class class$org$apache$commons$jxpath$JXPathContextFactory;

    protected JXPathContextFactory() {
    }

    public static JXPathContextFactory newInstance() {
        JXPathContextFactory factoryImpl;
        if (factoryImplName == null) {
            factoryImplName = JXPathContextFactory.findFactory(FACTORY_NAME_PROPERTY, DEFAULT_FACTORY_CLASS);
        }
        try {
            Class<?> clazz = Class.forName(factoryImplName);
            factoryImpl = (JXPathContextFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new JXPathContextFactoryConfigurationError(cnfe);
        }
        catch (IllegalAccessException iae) {
            throw new JXPathContextFactoryConfigurationError(iae);
        }
        catch (InstantiationException ie) {
            throw new JXPathContextFactoryConfigurationError(ie);
        }
        return factoryImpl;
    }

    public abstract JXPathContext newContext(JXPathContext var1, Object var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findFactory(String property, String defaultFactory) {
        block30: {
            block28: {
                try {
                    String systemProp = System.getProperty(property);
                    if (systemProp != null) {
                        if (debug) {
                            System.err.println("JXPath: found system property" + systemProp);
                        }
                        return systemProp;
                    }
                }
                catch (SecurityException se) {
                    // empty catch block
                }
                try {
                    String javah = System.getProperty("java.home");
                    String configFile = javah + File.separator + "lib" + File.separator + "jxpath.properties";
                    File f = new File(configFile);
                    if (!f.exists()) break block28;
                    Properties props = new Properties();
                    FileInputStream fis = new FileInputStream(f);
                    try {
                        props.load(fis);
                    }
                    finally {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    String factory = props.getProperty(property);
                    if (factory != null) {
                        if (debug) {
                            System.err.println("JXPath: found java.home property " + factory);
                        }
                        return factory;
                    }
                }
                catch (IOException ex) {
                    if (!debug) break block28;
                    ex.printStackTrace();
                }
            }
            String serviceId = "META-INF/services/" + property;
            try {
                ClassLoader cl = (class$org$apache$commons$jxpath$JXPathContextFactory == null ? (class$org$apache$commons$jxpath$JXPathContextFactory = JXPathContextFactory.class$(FACTORY_NAME_PROPERTY)) : class$org$apache$commons$jxpath$JXPathContextFactory).getClassLoader();
                InputStream is = null;
                is = cl == null ? ClassLoader.getSystemResourceAsStream(serviceId) : cl.getResourceAsStream(serviceId);
                if (is == null) break block30;
                if (debug) {
                    System.err.println("JXPath: found  " + serviceId);
                }
                BufferedReader rd = new BufferedReader(new InputStreamReader(is));
                String factory = null;
                try {
                    factory = rd.readLine();
                }
                finally {
                    try {
                        rd.close();
                    }
                    catch (IOException e) {}
                }
                if (factory != null && !"".equals(factory)) {
                    if (debug) {
                        System.err.println("JXPath: loaded from services: " + factory);
                    }
                    return factory;
                }
            }
            catch (Exception ex) {
                if (!debug) break block30;
                ex.printStackTrace();
            }
        }
        return defaultFactory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            debug = System.getProperty("jxpath.debug") != null;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

