/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.axes;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.EvalContext;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.compiler.NodeTest;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.model.NodeIterator;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.model.NodePointer;
import java.util.Stack;

public class DescendantContext
extends EvalContext {
    private NodeTest nodeTest;
    private boolean setStarted = false;
    private Stack stack = null;
    private NodePointer currentNodePointer = null;
    private boolean includeSelf;
    private static final NodeTest ELEMENT_NODE_TEST = new NodeTypeTest(1);

    public DescendantContext(EvalContext parentContext, boolean includeSelf, NodeTest nodeTest) {
        super(parentContext);
        this.includeSelf = includeSelf;
        this.nodeTest = nodeTest;
    }

    public boolean isChildOrderingRequired() {
        return true;
    }

    public NodePointer getCurrentNodePointer() {
        if (this.position == 0 && !this.setPosition(1)) {
            return null;
        }
        return this.currentNodePointer;
    }

    public void reset() {
        super.reset();
        this.setStarted = false;
    }

    public boolean setPosition(int position) {
        if (position < this.position) {
            this.reset();
        }
        while (this.position < position) {
            if (this.nextNode()) continue;
            return false;
        }
        return true;
    }

    public boolean nextNode() {
        if (!this.setStarted) {
            this.setStarted = true;
            if (this.stack == null) {
                this.stack = new Stack();
            } else {
                this.stack.clear();
            }
            this.currentNodePointer = this.parentContext.getCurrentNodePointer();
            if (this.currentNodePointer != null) {
                if (!this.currentNodePointer.isLeaf()) {
                    this.stack.push(this.currentNodePointer.childIterator(ELEMENT_NODE_TEST, false, null));
                }
                if (this.includeSelf && this.currentNodePointer.testNode(this.nodeTest)) {
                    ++this.position;
                    return true;
                }
            }
        }
        while (!this.stack.isEmpty()) {
            NodeIterator it = (NodeIterator)this.stack.peek();
            if (it.setPosition(it.getPosition() + 1)) {
                this.currentNodePointer = it.getNodePointer();
                if (this.isRecursive()) continue;
                if (!this.currentNodePointer.isLeaf()) {
                    this.stack.push(this.currentNodePointer.childIterator(ELEMENT_NODE_TEST, false, null));
                }
                if (!this.currentNodePointer.testNode(this.nodeTest)) continue;
                ++this.position;
                return true;
            }
            this.stack.pop();
        }
        return false;
    }

    private boolean isRecursive() {
        Object node = this.currentNodePointer.getNode();
        int i = this.stack.size() - 1;
        while (--i >= 0) {
            NodeIterator it = (NodeIterator)this.stack.get(i);
            NodePointer pointer = it.getNodePointer();
            if (pointer == null || pointer.getNode() != node) continue;
            return true;
        }
        return false;
    }
}

