/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.compiler;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.Function;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.JXPathFunctionNotFoundException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.NodeSet;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.EvalContext;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.QName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.axes.NodeSetContext;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.compiler.Expression;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.compiler.Operation;
import java.util.Arrays;

public class ExtensionFunction
extends Operation {
    private QName functionName;

    public ExtensionFunction(QName functionName, Expression[] args) {
        super(args);
        this.functionName = functionName;
    }

    public QName getFunctionName() {
        return this.functionName;
    }

    public boolean computeContextDependent() {
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.functionName);
        buffer.append('(');
        Expression[] args = this.getArguments();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(args[i]);
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    public Object compute(EvalContext context) {
        return this.computeValue(context);
    }

    public Object computeValue(EvalContext context) {
        Function function;
        Object[] parameters = null;
        if (this.args != null) {
            parameters = new Object[this.args.length];
            for (int i = 0; i < this.args.length; ++i) {
                parameters[i] = this.convert(this.args[i].compute(context));
            }
        }
        if ((function = context.getRootContext().getFunction(this.functionName, parameters)) == null) {
            throw new JXPathFunctionNotFoundException("No such function: " + this.functionName + Arrays.asList(parameters));
        }
        Object result = function.invoke(context, parameters);
        return result instanceof NodeSet ? new NodeSetContext(context, (NodeSet)result) : result;
    }

    private Object convert(Object object) {
        return object instanceof EvalContext ? ((EvalContext)object).getValue() : object;
    }
}

