/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.model.beans;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.JXPathBeanInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.JXPathIntrospector;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.QName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.model.NodePointer;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.model.beans.BeanPropertyPointer;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.model.beans.PropertyOwnerPointer;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.model.beans.PropertyPointer;
import java.util.Locale;

public class BeanPointer
extends PropertyOwnerPointer {
    private QName name;
    private Object bean;
    private JXPathBeanInfo beanInfo;
    private static final long serialVersionUID = -8227317938284982440L;

    public BeanPointer(QName name, Object bean, JXPathBeanInfo beanInfo, Locale locale) {
        super(null, locale);
        this.name = name;
        this.bean = bean;
        this.beanInfo = beanInfo;
    }

    public BeanPointer(NodePointer parent, QName name, Object bean, JXPathBeanInfo beanInfo) {
        super(parent);
        this.name = name;
        this.bean = bean;
        this.beanInfo = beanInfo;
    }

    public PropertyPointer getPropertyPointer() {
        return new BeanPropertyPointer((NodePointer)this, this.beanInfo);
    }

    public QName getName() {
        return this.name;
    }

    public Object getBaseValue() {
        return this.bean;
    }

    public boolean isCollection() {
        return false;
    }

    public int getLength() {
        return 1;
    }

    public boolean isLeaf() {
        Object value = this.getNode();
        return value == null || JXPathIntrospector.getBeanInfo(value.getClass()).isAtomic();
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean equals(Object object) {
        int iOther;
        if (object == this) {
            return true;
        }
        if (!(object instanceof BeanPointer)) {
            return false;
        }
        BeanPointer other = (BeanPointer)object;
        if (!(this.parent == other.parent || this.parent != null && this.parent.equals(other.parent))) {
            return false;
        }
        if (this.name == null && other.name != null || this.name != null && !this.name.equals(other.name)) {
            return false;
        }
        int iThis = this.index == Integer.MIN_VALUE ? 0 : this.index;
        int n = iOther = other.index == Integer.MIN_VALUE ? 0 : other.index;
        if (iThis != iOther) {
            return false;
        }
        if (this.bean instanceof Number || this.bean instanceof String || this.bean instanceof Boolean) {
            return this.bean.equals(other.bean);
        }
        return this.bean == other.bean;
    }

    public String asPath() {
        if (this.parent != null) {
            return super.asPath();
        }
        if (this.bean == null) {
            return "null()";
        }
        if (this.bean instanceof Number) {
            String string = this.bean.toString();
            if (string.endsWith(".0")) {
                string = string.substring(0, string.length() - 2);
            }
            return string;
        }
        if (this.bean instanceof Boolean) {
            return (Boolean)this.bean != false ? "true()" : "false()";
        }
        if (this.bean instanceof String) {
            return "'" + this.bean + "'";
        }
        return "/";
    }
}

