/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.model.beans;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.JXPathContext;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.QName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.model.NodePointer;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.model.beans.CollectionPointer;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.model.beans.NullPointer;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.model.beans.NullPropertyPointer;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.model.beans.PropertyPointer;

public class NullElementPointer
extends CollectionPointer {
    private static final long serialVersionUID = 8714236818791036721L;

    public NullElementPointer(NodePointer parent, int index) {
        super(parent, (Object)null);
        this.index = index;
    }

    public QName getName() {
        return null;
    }

    public Object getBaseValue() {
        return null;
    }

    public Object getImmediateNode() {
        return null;
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean isCollection() {
        return false;
    }

    public PropertyPointer getPropertyPointer() {
        return new NullPropertyPointer(this);
    }

    public NodePointer getValuePointer() {
        return new NullPointer((NodePointer)this, this.getName());
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException("Collection element does not exist: " + this);
    }

    public boolean isActual() {
        return false;
    }

    public boolean isContainer() {
        return true;
    }

    public NodePointer createPath(JXPathContext context) {
        return this.parent.createChild(context, null, this.index);
    }

    public NodePointer createPath(JXPathContext context, Object value) {
        return this.parent.createChild(context, null, this.index, value);
    }

    public int hashCode() {
        return this.getImmediateParentPointer().hashCode() + this.index;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NullElementPointer)) {
            return false;
        }
        NullElementPointer other = (NullElementPointer)object;
        return this.getImmediateParentPointer() == other.getImmediateParentPointer() && this.index == other.index;
    }

    public int getLength() {
        return 0;
    }

    public String asPath() {
        StringBuffer buffer = new StringBuffer();
        NodePointer parent = this.getImmediateParentPointer();
        if (parent != null) {
            buffer.append(parent.asPath());
        }
        if (this.index != Integer.MIN_VALUE) {
            if (parent != null && parent.getIndex() != Integer.MIN_VALUE) {
                buffer.append("/.");
            } else if (parent != null && parent.getImmediateParentPointer() != null && parent.getImmediateParentPointer().getIndex() != Integer.MIN_VALUE) {
                buffer.append("/.");
            }
            buffer.append("[").append(this.index + 1).append(']');
        }
        return buffer.toString();
    }
}

