/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.model.dom;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.QName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.model.NodeIterator;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.model.NodePointer;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.model.dom.DOMAttributePointer;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.jxpath.ri.model.dom.DOMNodePointer;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMAttributeIterator
implements NodeIterator {
    private NodePointer parent;
    private QName name;
    private List attributes;
    private int position = 0;

    public DOMAttributeIterator(NodePointer parent, QName name) {
        this.parent = parent;
        this.name = name;
        this.attributes = new ArrayList();
        Node node = (Node)parent.getNode();
        if (node.getNodeType() == 1) {
            String lname = name.getName();
            if (!lname.equals("*")) {
                Attr attr = this.getAttribute((Element)node, name);
                if (attr != null) {
                    this.attributes.add(attr);
                }
            } else {
                NamedNodeMap map = node.getAttributes();
                int count = map.getLength();
                for (int i = 0; i < count; ++i) {
                    Attr attr = (Attr)map.item(i);
                    if (!this.testAttr(attr)) continue;
                    this.attributes.add(attr);
                }
            }
        }
    }

    private boolean testAttr(Attr attr) {
        String nodePrefix = DOMNodePointer.getPrefix(attr);
        String nodeLocalName = DOMNodePointer.getLocalName(attr);
        if (nodePrefix != null && nodePrefix.equals("xmlns")) {
            return false;
        }
        if (nodePrefix == null && nodeLocalName.equals("xmlns")) {
            return false;
        }
        String testLocalName = this.name.getName();
        if (testLocalName.equals("*") || testLocalName.equals(nodeLocalName)) {
            String testPrefix = this.name.getPrefix();
            if (testPrefix == null || DOMAttributeIterator.equalStrings(testPrefix, nodePrefix)) {
                return true;
            }
            if (nodePrefix == null) {
                return false;
            }
            return DOMAttributeIterator.equalStrings(this.parent.getNamespaceURI(testPrefix), this.parent.getNamespaceURI(nodePrefix));
        }
        return false;
    }

    private static boolean equalStrings(String s1, String s2) {
        return s1 == s2 || s1 != null && s1.equals(s2);
    }

    private Attr getAttribute(Element element, QName name) {
        String testPrefix = name.getPrefix();
        String testNS = null;
        if (testPrefix != null) {
            testNS = this.parent.getNamespaceResolver().getNamespaceURI(testPrefix);
        }
        if (testNS != null) {
            Attr attr = element.getAttributeNodeNS(testNS, name.getName());
            if (attr != null) {
                return attr;
            }
            NamedNodeMap nnm = element.getAttributes();
            for (int i = 0; i < nnm.getLength(); ++i) {
                attr = (Attr)nnm.item(i);
                if (!this.testAttr(attr)) continue;
                return attr;
            }
            return null;
        }
        return element.getAttributeNode(name.getName());
    }

    public NodePointer getNodePointer() {
        int index;
        if (this.position == 0) {
            if (!this.setPosition(1)) {
                return null;
            }
            this.position = 0;
        }
        if ((index = this.position - 1) < 0) {
            index = 0;
        }
        return new DOMAttributePointer(this.parent, (Attr)this.attributes.get(index));
    }

    public int getPosition() {
        return this.position;
    }

    public boolean setPosition(int position) {
        this.position = position;
        return position >= 1 && position <= this.attributes.size();
    }
}

