/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileContentInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.RandomAccessContent;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.util.RandomAccessMode;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Map;

public interface FileContent
extends Closeable {
    @Override
    public void close() throws FileSystemException;

    public Object getAttribute(String var1) throws FileSystemException;

    public String[] getAttributeNames() throws FileSystemException;

    public Map<String, Object> getAttributes() throws FileSystemException;

    default public byte[] getByteArray() throws IOException {
        int pos;
        long sizeL = this.getSize();
        if (sizeL > Integer.MAX_VALUE) {
            throw new IllegalStateException(String.format("File content is too large for a byte array: %,d", sizeL));
        }
        boolean sizeUndefined = sizeL < 0L;
        int size = sizeUndefined ? 8192 : (int)sizeL;
        byte[] buf = new byte[size];
        try (InputStream in = this.getInputStream(size);){
            int read = 0;
            for (pos = 0; pos < size && read >= 0; pos += read) {
                read = in.read(buf, pos, size - pos);
            }
        }
        return sizeUndefined && pos < buf.length ? Arrays.copyOf(buf, ++pos) : buf;
    }

    public Certificate[] getCertificates() throws FileSystemException;

    public FileContentInfo getContentInfo() throws FileSystemException;

    public FileObject getFile();

    public InputStream getInputStream() throws FileSystemException;

    default public InputStream getInputStream(int bufferSize) throws FileSystemException {
        return this.getInputStream();
    }

    public long getLastModifiedTime() throws FileSystemException;

    public OutputStream getOutputStream() throws FileSystemException;

    public OutputStream getOutputStream(boolean var1) throws FileSystemException;

    default public OutputStream getOutputStream(boolean bAppend, int bufferSize) throws FileSystemException {
        return this.getOutputStream(bAppend);
    }

    default public OutputStream getOutputStream(int bufferSize) throws FileSystemException {
        return this.getOutputStream();
    }

    public RandomAccessContent getRandomAccessContent(RandomAccessMode var1) throws FileSystemException;

    public long getSize() throws FileSystemException;

    default public String getString(Charset charset) throws IOException {
        return new String(this.getByteArray(), charset == null ? Charset.defaultCharset() : charset);
    }

    default public String getString(String charset) throws IOException {
        return new String(this.getByteArray(), charset == null ? Charset.defaultCharset().name() : charset);
    }

    public boolean hasAttribute(String var1) throws FileSystemException;

    default public boolean isEmpty() throws FileSystemException {
        return this.getSize() <= 0L;
    }

    public boolean isOpen();

    public void removeAttribute(String var1) throws FileSystemException;

    public void setAttribute(String var1, Object var2) throws FileSystemException;

    public void setLastModifiedTime(long var1) throws FileSystemException;

    public long write(FileContent var1) throws IOException;

    public long write(FileObject var1) throws IOException;

    public long write(OutputStream var1) throws IOException;

    public long write(OutputStream var1, int var2) throws IOException;
}

