/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSelectInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSelector;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class FileExtensionSelector
implements FileSelector {
    private final Set<String> extensions = new HashSet<String>();

    public FileExtensionSelector(Collection<String> extensions) {
        if (extensions != null) {
            this.extensions.addAll(extensions);
        }
    }

    public FileExtensionSelector(String ... extensions) {
        if (extensions != null) {
            this.extensions.addAll(Arrays.asList(extensions));
        }
    }

    @Override
    public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
        if (this.extensions == null) {
            return false;
        }
        for (String extension : this.extensions) {
            if (!fileInfo.getFile().getName().getExtension().equalsIgnoreCase(extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
        return true;
    }
}

