/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class VFS {
    private static FileSystemManager instance;
    private static Boolean uriStyle;

    private static FileSystemManager createFileSystemManager(String managerClassName) throws FileSystemException {
        try {
            Class<?> mgrClass = Class.forName(managerClassName);
            FileSystemManager mgr = (FileSystemManager)mgrClass.newInstance();
            try {
                Method initMethod = mgrClass.getMethod("init", null);
                initMethod.invoke((Object)mgr, (Object[])null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return mgr;
        }
        catch (InvocationTargetException e) {
            throw new FileSystemException("vfs/create-manager.error", (Object)managerClassName, e.getTargetException());
        }
        catch (Exception e) {
            throw new FileSystemException("vfs/create-manager.error", (Object)managerClassName, (Throwable)e);
        }
    }

    public static synchronized FileSystemManager getManager() throws FileSystemException {
        if (instance == null) {
            instance = VFS.reset();
        }
        return instance;
    }

    public static boolean isUriStyle() {
        if (uriStyle == null) {
            uriStyle = Boolean.FALSE;
        }
        return uriStyle;
    }

    public static FileSystemManager reset() throws FileSystemException {
        if (instance != null) {
            instance.close();
        }
        instance = VFS.createFileSystemManager("consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.impl.StandardFileSystemManager");
        return instance;
    }

    public static synchronized void setManager(FileSystemManager manager) {
        instance = manager;
    }

    public static void setUriStyle(boolean uriStyle) {
        if (VFS.uriStyle != null && VFS.uriStyle != uriStyle) {
            throw new IllegalStateException("VFS.uriStyle was already set differently.");
        }
        VFS.uriStyle = uriStyle;
    }

    private VFS() {
    }
}

