/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.auth;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.logging.Log;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.logging.LogFactory;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.UserAuthenticationData;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.UserAuthenticator;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.util.UserAuthenticatorUtils;

public class StaticUserAuthenticator
implements UserAuthenticator,
Comparable<StaticUserAuthenticator> {
    private static final Log LOG = LogFactory.getLog(StaticUserAuthenticator.class);
    private final String username;
    private final String password;
    private final String domain;

    public StaticUserAuthenticator(String domain, String username, String password) {
        this.username = username;
        this.password = password;
        this.domain = domain;
    }

    @Override
    public UserAuthenticationData requestAuthentication(UserAuthenticationData.Type[] types) {
        UserAuthenticationData data = new UserAuthenticationData();
        for (UserAuthenticationData.Type type : types) {
            if (type == UserAuthenticationData.DOMAIN) {
                data.setData(UserAuthenticationData.DOMAIN, UserAuthenticatorUtils.toChar(this.domain));
                continue;
            }
            if (type == UserAuthenticationData.USERNAME) {
                data.setData(UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(this.username));
                continue;
            }
            if (type == UserAuthenticationData.PASSWORD) {
                data.setData(UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(this.password));
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(StaticUserAuthenticator.class.getSimpleName() + " does not support authentication data type '" + type + "'; authentication request for this type ignored.");
        }
        return data;
    }

    public int hashCode() {
        int prime = 37;
        int result = 1;
        result = 37 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 37 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 37 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StaticUserAuthenticator other = (StaticUserAuthenticator)obj;
        return this.equalsNullsafe(this.domain, other.domain) && this.equalsNullsafe(this.username, other.username) && this.equalsNullsafe(this.password, other.password);
    }

    private boolean equalsNullsafe(String thisString, String otherString) {
        return !(thisString == null ? otherString != null : !thisString.equals(otherString));
    }

    @Override
    public int compareTo(StaticUserAuthenticator other) {
        int result = this.compareStringOrNull(this.domain, other.domain);
        result = result == 0 ? this.compareStringOrNull(this.username, other.username) : result;
        result = result == 0 ? this.compareStringOrNull(this.password, other.password) : result;
        return result;
    }

    private int compareStringOrNull(String thisString, String otherString) {
        if (thisString == null) {
            if (otherString != null) {
                return -1;
            }
        } else {
            if (otherString == null) {
                return 1;
            }
            int result = thisString.compareTo(otherString);
            if (result != 0) {
                return result;
            }
        }
        return 0;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.domain != null) {
            buffer.append(this.domain).append('\\');
        }
        if (this.username != null) {
            buffer.append(this.username);
        } else {
            buffer.append("(null)");
        }
        if (this.password != null) {
            buffer.append(":***");
        }
        return buffer.toString();
    }
}

