/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.filter;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileContent;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileFilter;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSelectInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import java.io.Serializable;
import java.util.Date;

public class AgeFileFilter
implements FileFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean acceptOlder;
    private final long cutoff;

    private static boolean isFileNewer(FileObject fileObject, long timeMillis) throws FileSystemException {
        if (fileObject == null) {
            throw new IllegalArgumentException("No specified file");
        }
        if (!fileObject.exists()) {
            return false;
        }
        try (FileContent content = fileObject.getContent();){
            long lastModified = content.getLastModifiedTime();
            boolean bl = lastModified > timeMillis;
            return bl;
        }
    }

    public AgeFileFilter(Date cutoffDate) {
        this(cutoffDate, true);
    }

    public AgeFileFilter(Date cutoffDate, boolean acceptOlder) {
        this(cutoffDate.getTime(), acceptOlder);
    }

    public AgeFileFilter(FileObject cutoffReference) throws FileSystemException {
        this(cutoffReference, true);
    }

    public AgeFileFilter(FileObject cutoffReference, boolean acceptOlder) throws FileSystemException {
        this(cutoffReference.getContent().getLastModifiedTime(), acceptOlder);
    }

    public AgeFileFilter(long cutoff) {
        this(cutoff, true);
    }

    public AgeFileFilter(long cutoff, boolean acceptOlder) {
        this.acceptOlder = acceptOlder;
        this.cutoff = cutoff;
    }

    @Override
    public boolean accept(FileSelectInfo fileInfo) throws FileSystemException {
        boolean newer = AgeFileFilter.isFileNewer(fileInfo.getFile(), this.cutoff);
        return this.acceptOlder ? !newer : newer;
    }

    public String toString() {
        String condition = this.acceptOlder ? "<=" : ">";
        return super.toString() + "(" + condition + this.cutoff + ")";
    }
}

