/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.filter;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileFilter;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSelectInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.filter.IOCase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NameFileFilter
implements FileFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IOCase caseSensitivity;
    private final List<String> names;

    public NameFileFilter(List<String> names) {
        this((IOCase)null, names);
    }

    public NameFileFilter(IOCase caseSensitivity, List<String> names) {
        if (names == null) {
            throw new IllegalArgumentException("The list of names must not be null");
        }
        this.names = new ArrayList<String>(names);
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    public NameFileFilter(String ... names) {
        this((IOCase)null, names);
    }

    public NameFileFilter(IOCase caseSensitivity, String ... names) {
        if (names == null) {
            throw new IllegalArgumentException("The array of names must not be null");
        }
        this.names = new ArrayList<String>(Arrays.asList(names));
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    @Override
    public boolean accept(FileSelectInfo fileInfo) {
        String name = fileInfo.getFile().getName().getBaseName();
        for (String name2 : this.names) {
            if (!this.caseSensitivity.checkEquals(name, name2)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        buffer.append("(");
        if (this.names != null) {
            for (int i = 0; i < this.names.size(); ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(this.names.get(i));
            }
        }
        buffer.append(")");
        return buffer.toString();
    }
}

