/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.filter;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileFilter;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSelectInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.filter.IOCase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PrefixFileFilter
implements FileFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IOCase caseSensitivity;
    private final List<String> prefixes;

    public PrefixFileFilter(List<String> prefixes) {
        this(IOCase.SENSITIVE, prefixes);
    }

    public PrefixFileFilter(IOCase caseSensitivity, List<String> prefixes) {
        if (prefixes == null) {
            throw new IllegalArgumentException("The list of prefixes must not be null");
        }
        this.prefixes = new ArrayList<String>(prefixes);
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    public PrefixFileFilter(String ... prefixes) {
        this(IOCase.SENSITIVE, prefixes);
    }

    public PrefixFileFilter(IOCase caseSensitivity, String ... prefixes) {
        if (prefixes == null) {
            throw new IllegalArgumentException("The array of prefixes must not be null");
        }
        this.prefixes = new ArrayList<String>(Arrays.asList(prefixes));
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    @Override
    public boolean accept(FileSelectInfo fileInfo) {
        String name = fileInfo.getFile().getName().getBaseName();
        for (String prefix : this.prefixes) {
            if (!this.caseSensitivity.checkStartsWith(name, prefix)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        buffer.append("(");
        if (this.prefixes != null) {
            for (int i = 0; i < this.prefixes.size(); ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(this.prefixes.get(i));
            }
        }
        buffer.append(")");
        return buffer.toString();
    }
}

