/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.filter;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileFilter;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSelectInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.filter.IOCase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;

public class WildcardFileFilter
implements FileFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IOCase caseSensitivity;
    private final List<String> wildcards;

    public WildcardFileFilter(List<String> wildcards) {
        this((IOCase)null, wildcards);
    }

    public WildcardFileFilter(IOCase caseSensitivity, List<String> wildcards) {
        if (wildcards == null) {
            throw new IllegalArgumentException("The wildcard list must not be null");
        }
        this.wildcards = new ArrayList<String>(wildcards);
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    public WildcardFileFilter(String ... wildcards) {
        this((IOCase)null, wildcards);
    }

    public WildcardFileFilter(IOCase caseSensitivity, String ... wildcards) {
        if (wildcards == null) {
            throw new IllegalArgumentException("The wildcard array must not be null");
        }
        this.wildcards = new ArrayList<String>(Arrays.asList(wildcards));
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    @Override
    public boolean accept(FileSelectInfo fileInfo) {
        String name = fileInfo.getFile().getName().getBaseName();
        for (String wildcard : this.wildcards) {
            if (!WildcardFileFilter.wildcardMatch(name, wildcard, this.caseSensitivity)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        buffer.append("(");
        if (this.wildcards != null) {
            for (int i = 0; i < this.wildcards.size(); ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(this.wildcards.get(i));
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    static String[] splitOnTokens(String text) {
        if (text.indexOf(63) == -1 && text.indexOf(42) == -1) {
            return new String[]{text};
        }
        char[] array = text.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == '?' || array[i] == '*') {
                if (buffer.length() != 0) {
                    list.add(buffer.toString());
                    buffer.setLength(0);
                }
                if (array[i] == '?') {
                    list.add("?");
                    continue;
                }
                if (!list.isEmpty() && (i <= 0 || ((String)list.get(list.size() - 1)).equals("*"))) continue;
                list.add("*");
                continue;
            }
            buffer.append(array[i]);
        }
        if (buffer.length() != 0) {
            list.add(buffer.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    static boolean wildcardMatch(String fileName, String wildcardMatcher, IOCase caseSensitivity) {
        if (fileName == null && wildcardMatcher == null) {
            return true;
        }
        if (fileName == null || wildcardMatcher == null) {
            return false;
        }
        if (caseSensitivity == null) {
            caseSensitivity = IOCase.SENSITIVE;
        }
        String[] wcs = WildcardFileFilter.splitOnTokens(wildcardMatcher);
        boolean anyChars = false;
        int textIdx = 0;
        int wcsIdx = 0;
        Stack<int[]> backtrack = new Stack<int[]>();
        do {
            if (backtrack.size() > 0) {
                int[] array = (int[])backtrack.pop();
                wcsIdx = array[0];
                textIdx = array[1];
                anyChars = true;
            }
            while (wcsIdx < wcs.length) {
                if (wcs[wcsIdx].equals("?")) {
                    if (++textIdx > fileName.length()) break;
                    anyChars = false;
                } else if (wcs[wcsIdx].equals("*")) {
                    anyChars = true;
                    if (wcsIdx == wcs.length - 1) {
                        textIdx = fileName.length();
                    }
                } else {
                    if (anyChars) {
                        if ((textIdx = caseSensitivity.checkIndexOf(fileName, textIdx, wcs[wcsIdx])) == -1) break;
                        int repeat = caseSensitivity.checkIndexOf(fileName, textIdx + 1, wcs[wcsIdx]);
                        if (repeat >= 0) {
                            backtrack.push(new int[]{wcsIdx, repeat});
                        }
                    } else if (!caseSensitivity.checkRegionMatches(fileName, textIdx, wcs[wcsIdx])) break;
                    textIdx += wcs[wcsIdx].length();
                    anyChars = false;
                }
                ++wcsIdx;
            }
            if (wcsIdx != wcs.length || textIdx != fileName.length()) continue;
            return true;
        } while (backtrack.size() > 0);
        return false;
    }
}

