/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.impl;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileType;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.impl.VirtualFileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.impl.VirtualFileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractFileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractFileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractVfsContainer;

public class VirtualFileProvider
extends AbstractVfsContainer {
    public FileObject createFileSystem(FileObject rootFile) throws FileSystemException {
        AbstractFileName rootName = (AbstractFileName)this.getContext().getFileSystemManager().resolveName(rootFile.getName(), "/");
        VirtualFileSystem fs = new VirtualFileSystem(rootName, rootFile.getFileSystem().getFileSystemOptions());
        this.addComponent(fs);
        fs.addJunction("/", rootFile);
        return fs.getRoot();
    }

    public FileObject createFileSystem(String rootUri) throws FileSystemException {
        VirtualFileName rootName = new VirtualFileName(rootUri, "/", FileType.FOLDER);
        VirtualFileSystem fs = new VirtualFileSystem(rootName, null);
        this.addComponent(fs);
        return fs.getRoot();
    }

    void closeFileSystem(FileSystem fileSystem) {
        AbstractFileSystem fs = (AbstractFileSystem)fileSystem;
        this.removeComponent(fs);
        fs.close();
    }
}

