/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemOptions;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractFileProvider;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.LayeredFileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.LayeredFileNameParser;

public abstract class AbstractLayeredFileProvider
extends AbstractFileProvider {
    public AbstractLayeredFileProvider() {
        this.setFileNameParser(LayeredFileNameParser.getInstance());
    }

    @Override
    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        LayeredFileName name = (LayeredFileName)this.parseUri(baseFile != null ? baseFile.getName() : null, uri);
        FileName fileName = name.getOuterName();
        FileObject file = this.getContext().resolveFile(baseFile, fileName.getURI(), fileSystemOptions);
        FileObject rootFile = this.createFileSystem(name.getScheme(), file, fileSystemOptions);
        return rootFile.resolveFile(name.getPath());
    }

    @Override
    public synchronized FileObject createFileSystem(String scheme, FileObject file, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName rootName = file.getName();
        FileSystem fs = this.findFileSystem(rootName, fileSystemOptions);
        if (fs == null) {
            fs = this.doCreateFileSystem(scheme, file, fileSystemOptions);
            this.addFileSystem(rootName, fs);
        }
        return fs.getRoot();
    }

    protected abstract FileSystem doCreateFileSystem(String var1, FileObject var2, FileSystemOptions var3) throws FileSystemException;
}

