/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemOptions;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractFileProvider;

public abstract class AbstractOriginatingFileProvider
extends AbstractFileProvider {
    @Override
    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName name;
        try {
            name = this.parseUri(baseFile != null ? baseFile.getName() : null, uri);
        }
        catch (FileSystemException exc) {
            throw new FileSystemException("vfs.provider/invalid-absolute-uri.error", (Object)uri, (Throwable)exc);
        }
        return this.findFile(name, fileSystemOptions);
    }

    protected FileObject findFile(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName rootName = this.getContext().getFileSystemManager().resolveName(name, "/");
        FileSystem fs = this.getFileSystem(rootName, fileSystemOptions);
        return fs.resolveFile(name);
    }

    protected synchronized FileSystem getFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileSystem fs = this.findFileSystem(rootName, fileSystemOptions);
        if (fs == null) {
            fs = this.doCreateFileSystem(rootName, fileSystemOptions);
            this.addFileSystem(rootName, fs);
        }
        return fs;
    }

    protected abstract FileSystem doCreateFileSystem(FileName var1, FileSystemOptions var2) throws FileSystemException;
}

