/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileType;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractFileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.UriParser;

public class GenericFileName
extends AbstractFileName {
    private static final char[] USERNAME_RESERVED = new char[]{':', '@', '/'};
    private static final char[] PASSWORD_RESERVED = new char[]{'@', '/', '?'};
    private final String userName;
    private final String hostName;
    private final int defaultPort;
    private final String password;
    private final int port;

    protected GenericFileName(String scheme, String hostName, int port, int defaultPort, String userName, String password, String path, FileType type) {
        super(scheme, path, type);
        this.hostName = hostName;
        this.defaultPort = defaultPort;
        this.password = password;
        this.userName = userName;
        this.port = port > 0 ? port : this.getDefaultPort();
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    @Override
    public FileName createName(String absPath, FileType type) {
        return new GenericFileName(this.getScheme(), this.hostName, this.port, this.defaultPort, this.userName, this.password, absPath, type);
    }

    @Override
    protected void appendRootUri(StringBuilder buffer, boolean addPassword) {
        buffer.append(this.getScheme());
        buffer.append("://");
        this.appendCredentials(buffer, addPassword);
        buffer.append(this.hostName);
        if (this.port != this.getDefaultPort()) {
            buffer.append(':');
            buffer.append(this.port);
        }
    }

    protected void appendCredentials(StringBuilder buffer, boolean addPassword) {
        if (this.userName != null && this.userName.length() != 0) {
            UriParser.appendEncoded(buffer, this.userName, USERNAME_RESERVED);
            if (this.password != null && this.password.length() != 0) {
                buffer.append(':');
                if (addPassword) {
                    UriParser.appendEncoded(buffer, this.password, PASSWORD_RESERVED);
                } else {
                    buffer.append("***");
                }
            }
            buffer.append('@');
        }
    }
}

