/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileType;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.GenericURLFileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.HostFileNameParser;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.UriParser;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.VfsComponentContext;

public class GenericURLFileNameParser
extends HostFileNameParser {
    public GenericURLFileNameParser(int defaultPort) {
        super(defaultPort);
    }

    @Override
    public boolean encodeCharacter(char ch) {
        return super.encodeCharacter(ch) || ch == '?';
    }

    @Override
    public FileName parseUri(VfsComponentContext context, FileName base, String fileName) throws FileSystemException {
        StringBuilder name = new StringBuilder();
        HostFileNameParser.Authority auth = this.extractToPath(context, fileName, name);
        String queryString = UriParser.extractQueryString(name);
        UriParser.canonicalizePath(name, 0, name.length(), this);
        UriParser.fixSeparators(name);
        FileType fileType = UriParser.normalisePath(name);
        String path = name.toString();
        return new GenericURLFileName(auth.getScheme(), auth.getHostName(), auth.getPort(), this.getDefaultPort(), auth.getUserName(), auth.getPassword(), path, fileType, queryString);
    }
}

