/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.bzip2;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractFileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.bzip2.Bzip2FileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.compressed.CompressedFileFileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.compressed.CompressedFileFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Bzip2FileObject
extends CompressedFileFileObject<Bzip2FileSystem> {
    @Deprecated
    protected Bzip2FileObject(AbstractFileName name, FileObject container, CompressedFileFileSystem fs) {
        super(name, container, Bzip2FileObject.cast(fs));
    }

    protected Bzip2FileObject(AbstractFileName name, FileObject container, Bzip2FileSystem fs) {
        super(name, container, fs);
    }

    @Override
    protected InputStream doGetInputStream(int bufferSize) throws Exception {
        return Bzip2FileObject.wrapInputStream(this.getName().getURI(), this.getContainer().getContent().getInputStream(bufferSize));
    }

    public static InputStream wrapInputStream(String name, InputStream inputStream) throws IOException {
        return new BZip2CompressorInputStream(inputStream);
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        return new BZip2CompressorOutputStream(this.getContainer().getContent().getOutputStream(false));
    }

    private static Bzip2FileSystem cast(CompressedFileFileSystem fs) {
        if (fs instanceof Bzip2FileSystem) {
            return (Bzip2FileSystem)fs;
        }
        throw new IllegalArgumentException("Bzip2FileObject requires a Bzip2FileSystem implementation");
    }
}

