/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.compressed;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.Capability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileType;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractFileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractFileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.compressed.CompressedFileFileSystem;

public abstract class CompressedFileFileObject<FS extends CompressedFileFileSystem>
extends AbstractFileObject<FS> {
    public static final int SIZE_UNDEFINED = -1;
    private final FileObject container;
    private final String[] children;

    protected CompressedFileFileObject(AbstractFileName name, FileObject container, FS fs) {
        super(name, fs);
        this.container = container;
        String basename = container.getName().getBaseName();
        int pos = basename.lastIndexOf(46);
        if (pos > 0) {
            basename = basename.substring(0, pos);
        }
        this.children = new String[]{basename};
    }

    @Override
    public boolean isWriteable() throws FileSystemException {
        return this.getFileSystem().hasCapability(Capability.WRITE_CONTENT);
    }

    @Override
    protected FileType doGetType() throws FileSystemException {
        if (this.getName().getPath().endsWith("/")) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    @Override
    protected String[] doListChildren() {
        return this.children;
    }

    @Override
    protected long doGetContentSize() {
        return -1L;
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        return this.container.getContent().getLastModifiedTime();
    }

    protected FileObject getContainer() {
        return this.container;
    }

    @Override
    public void createFile() throws FileSystemException {
        this.container.createFile();
        this.injectType(FileType.FILE);
    }
}

