/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.ftp;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.logging.Log;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.logging.LogFactory;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.Capability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemOptions;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.VfsLog;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractFileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractFileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.GenericFileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.ftp.FTPClientWrapper;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.ftp.FtpClient;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.ftp.FtpFileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.ftp.FtpFileProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;

public class FtpFileSystem
extends AbstractFileSystem {
    private static final Log LOG = LogFactory.getLog(FtpFileSystem.class);
    private final AtomicReference<FtpClient> idleClient = new AtomicReference();

    public FtpFileSystem(GenericFileName rootName, FtpClient ftpClient, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
        this.idleClient.set(ftpClient);
    }

    @Override
    protected void doCloseCommunicationLink() {
        FtpClient idle = this.idleClient.getAndSet(null);
        if (idle != null) {
            this.closeConnection(idle);
        }
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(FtpFileProvider.capabilities);
    }

    private void closeConnection(FtpClient client) {
        try {
            if (client.isConnected()) {
                client.disconnect();
            }
        }
        catch (IOException e) {
            VfsLog.warn(this.getLogger(), LOG, "vfs.provider.ftp/close-connection.error", e);
        }
    }

    public FtpClient getClient() throws FileSystemException {
        FtpClient client = this.idleClient.getAndSet(null);
        if (client == null || !client.isConnected()) {
            client = this.createWrapper();
        }
        return client;
    }

    protected FTPClientWrapper createWrapper() throws FileSystemException {
        return new FTPClientWrapper((GenericFileName)this.getRoot().getName(), this.getFileSystemOptions());
    }

    public void putClient(FtpClient client) {
        if (!this.idleClient.compareAndSet(null, client)) {
            this.closeConnection(client);
        }
    }

    @Override
    protected FileObject createFile(AbstractFileName name) throws FileSystemException {
        return new FtpFileObject(name, this, this.getRootName());
    }
}

